/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.deadline.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.deadline.model.AcceleratorCountRange;
import com.amazonaws.services.deadline.model.AcceleratorTotalMemoryMiBRange;
import com.amazonaws.services.deadline.model.AcceleratorType;
import com.amazonaws.services.deadline.model.CpuArchitectureType;
import com.amazonaws.services.deadline.model.CustomerManagedFleetOperatingSystemFamily;
import com.amazonaws.services.deadline.model.FleetAmountCapability;
import com.amazonaws.services.deadline.model.FleetAttributeCapability;
import com.amazonaws.services.deadline.model.MemoryMiBRange;
import com.amazonaws.services.deadline.model.VCpuCountRange;
import com.amazonaws.services.deadline.model.transform.CustomerManagedWorkerCapabilitiesMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CustomerManagedWorkerCapabilities
implements Serializable,
Cloneable,
StructuredPojo {
    private AcceleratorCountRange acceleratorCount;
    private AcceleratorTotalMemoryMiBRange acceleratorTotalMemoryMiB;
    private List<String> acceleratorTypes;
    private String cpuArchitectureType;
    private List<FleetAmountCapability> customAmounts;
    private List<FleetAttributeCapability> customAttributes;
    private MemoryMiBRange memoryMiB;
    private String osFamily;
    private VCpuCountRange vCpuCount;

    public void setAcceleratorCount(AcceleratorCountRange acceleratorCount) {
        this.acceleratorCount = acceleratorCount;
    }

    public AcceleratorCountRange getAcceleratorCount() {
        return this.acceleratorCount;
    }

    public CustomerManagedWorkerCapabilities withAcceleratorCount(AcceleratorCountRange acceleratorCount) {
        this.setAcceleratorCount(acceleratorCount);
        return this;
    }

    public void setAcceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRange acceleratorTotalMemoryMiB) {
        this.acceleratorTotalMemoryMiB = acceleratorTotalMemoryMiB;
    }

    public AcceleratorTotalMemoryMiBRange getAcceleratorTotalMemoryMiB() {
        return this.acceleratorTotalMemoryMiB;
    }

    public CustomerManagedWorkerCapabilities withAcceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRange acceleratorTotalMemoryMiB) {
        this.setAcceleratorTotalMemoryMiB(acceleratorTotalMemoryMiB);
        return this;
    }

    public List<String> getAcceleratorTypes() {
        return this.acceleratorTypes;
    }

    public void setAcceleratorTypes(Collection<String> acceleratorTypes) {
        if (acceleratorTypes == null) {
            this.acceleratorTypes = null;
            return;
        }
        this.acceleratorTypes = new ArrayList<String>(acceleratorTypes);
    }

    public CustomerManagedWorkerCapabilities withAcceleratorTypes(String ... acceleratorTypes) {
        if (this.acceleratorTypes == null) {
            this.setAcceleratorTypes(new ArrayList<String>(acceleratorTypes.length));
        }
        for (String ele : acceleratorTypes) {
            this.acceleratorTypes.add(ele);
        }
        return this;
    }

    public CustomerManagedWorkerCapabilities withAcceleratorTypes(Collection<String> acceleratorTypes) {
        this.setAcceleratorTypes(acceleratorTypes);
        return this;
    }

    public CustomerManagedWorkerCapabilities withAcceleratorTypes(AcceleratorType ... acceleratorTypes) {
        ArrayList<String> acceleratorTypesCopy = new ArrayList<String>(acceleratorTypes.length);
        for (AcceleratorType value : acceleratorTypes) {
            acceleratorTypesCopy.add(value.toString());
        }
        if (this.getAcceleratorTypes() == null) {
            this.setAcceleratorTypes(acceleratorTypesCopy);
        } else {
            this.getAcceleratorTypes().addAll(acceleratorTypesCopy);
        }
        return this;
    }

    public void setCpuArchitectureType(String cpuArchitectureType) {
        this.cpuArchitectureType = cpuArchitectureType;
    }

    public String getCpuArchitectureType() {
        return this.cpuArchitectureType;
    }

    public CustomerManagedWorkerCapabilities withCpuArchitectureType(String cpuArchitectureType) {
        this.setCpuArchitectureType(cpuArchitectureType);
        return this;
    }

    public CustomerManagedWorkerCapabilities withCpuArchitectureType(CpuArchitectureType cpuArchitectureType) {
        this.cpuArchitectureType = cpuArchitectureType.toString();
        return this;
    }

    public List<FleetAmountCapability> getCustomAmounts() {
        return this.customAmounts;
    }

    public void setCustomAmounts(Collection<FleetAmountCapability> customAmounts) {
        if (customAmounts == null) {
            this.customAmounts = null;
            return;
        }
        this.customAmounts = new ArrayList<FleetAmountCapability>(customAmounts);
    }

    public CustomerManagedWorkerCapabilities withCustomAmounts(FleetAmountCapability ... customAmounts) {
        if (this.customAmounts == null) {
            this.setCustomAmounts(new ArrayList<FleetAmountCapability>(customAmounts.length));
        }
        for (FleetAmountCapability ele : customAmounts) {
            this.customAmounts.add(ele);
        }
        return this;
    }

    public CustomerManagedWorkerCapabilities withCustomAmounts(Collection<FleetAmountCapability> customAmounts) {
        this.setCustomAmounts(customAmounts);
        return this;
    }

    public List<FleetAttributeCapability> getCustomAttributes() {
        return this.customAttributes;
    }

    public void setCustomAttributes(Collection<FleetAttributeCapability> customAttributes) {
        if (customAttributes == null) {
            this.customAttributes = null;
            return;
        }
        this.customAttributes = new ArrayList<FleetAttributeCapability>(customAttributes);
    }

    public CustomerManagedWorkerCapabilities withCustomAttributes(FleetAttributeCapability ... customAttributes) {
        if (this.customAttributes == null) {
            this.setCustomAttributes(new ArrayList<FleetAttributeCapability>(customAttributes.length));
        }
        for (FleetAttributeCapability ele : customAttributes) {
            this.customAttributes.add(ele);
        }
        return this;
    }

    public CustomerManagedWorkerCapabilities withCustomAttributes(Collection<FleetAttributeCapability> customAttributes) {
        this.setCustomAttributes(customAttributes);
        return this;
    }

    public void setMemoryMiB(MemoryMiBRange memoryMiB) {
        this.memoryMiB = memoryMiB;
    }

    public MemoryMiBRange getMemoryMiB() {
        return this.memoryMiB;
    }

    public CustomerManagedWorkerCapabilities withMemoryMiB(MemoryMiBRange memoryMiB) {
        this.setMemoryMiB(memoryMiB);
        return this;
    }

    public void setOsFamily(String osFamily) {
        this.osFamily = osFamily;
    }

    public String getOsFamily() {
        return this.osFamily;
    }

    public CustomerManagedWorkerCapabilities withOsFamily(String osFamily) {
        this.setOsFamily(osFamily);
        return this;
    }

    public CustomerManagedWorkerCapabilities withOsFamily(CustomerManagedFleetOperatingSystemFamily osFamily) {
        this.osFamily = osFamily.toString();
        return this;
    }

    public void setVCpuCount(VCpuCountRange vCpuCount) {
        this.vCpuCount = vCpuCount;
    }

    public VCpuCountRange getVCpuCount() {
        return this.vCpuCount;
    }

    public CustomerManagedWorkerCapabilities withVCpuCount(VCpuCountRange vCpuCount) {
        this.setVCpuCount(vCpuCount);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAcceleratorCount() != null) {
            sb.append("AcceleratorCount: ").append(this.getAcceleratorCount()).append(",");
        }
        if (this.getAcceleratorTotalMemoryMiB() != null) {
            sb.append("AcceleratorTotalMemoryMiB: ").append(this.getAcceleratorTotalMemoryMiB()).append(",");
        }
        if (this.getAcceleratorTypes() != null) {
            sb.append("AcceleratorTypes: ").append(this.getAcceleratorTypes()).append(",");
        }
        if (this.getCpuArchitectureType() != null) {
            sb.append("CpuArchitectureType: ").append(this.getCpuArchitectureType()).append(",");
        }
        if (this.getCustomAmounts() != null) {
            sb.append("CustomAmounts: ").append(this.getCustomAmounts()).append(",");
        }
        if (this.getCustomAttributes() != null) {
            sb.append("CustomAttributes: ").append(this.getCustomAttributes()).append(",");
        }
        if (this.getMemoryMiB() != null) {
            sb.append("MemoryMiB: ").append(this.getMemoryMiB()).append(",");
        }
        if (this.getOsFamily() != null) {
            sb.append("OsFamily: ").append(this.getOsFamily()).append(",");
        }
        if (this.getVCpuCount() != null) {
            sb.append("VCpuCount: ").append(this.getVCpuCount());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerManagedWorkerCapabilities)) {
            return false;
        }
        CustomerManagedWorkerCapabilities other = (CustomerManagedWorkerCapabilities)obj;
        if (other.getAcceleratorCount() == null ^ this.getAcceleratorCount() == null) {
            return false;
        }
        if (other.getAcceleratorCount() != null && !other.getAcceleratorCount().equals(this.getAcceleratorCount())) {
            return false;
        }
        if (other.getAcceleratorTotalMemoryMiB() == null ^ this.getAcceleratorTotalMemoryMiB() == null) {
            return false;
        }
        if (other.getAcceleratorTotalMemoryMiB() != null && !other.getAcceleratorTotalMemoryMiB().equals(this.getAcceleratorTotalMemoryMiB())) {
            return false;
        }
        if (other.getAcceleratorTypes() == null ^ this.getAcceleratorTypes() == null) {
            return false;
        }
        if (other.getAcceleratorTypes() != null && !other.getAcceleratorTypes().equals(this.getAcceleratorTypes())) {
            return false;
        }
        if (other.getCpuArchitectureType() == null ^ this.getCpuArchitectureType() == null) {
            return false;
        }
        if (other.getCpuArchitectureType() != null && !other.getCpuArchitectureType().equals(this.getCpuArchitectureType())) {
            return false;
        }
        if (other.getCustomAmounts() == null ^ this.getCustomAmounts() == null) {
            return false;
        }
        if (other.getCustomAmounts() != null && !other.getCustomAmounts().equals(this.getCustomAmounts())) {
            return false;
        }
        if (other.getCustomAttributes() == null ^ this.getCustomAttributes() == null) {
            return false;
        }
        if (other.getCustomAttributes() != null && !other.getCustomAttributes().equals(this.getCustomAttributes())) {
            return false;
        }
        if (other.getMemoryMiB() == null ^ this.getMemoryMiB() == null) {
            return false;
        }
        if (other.getMemoryMiB() != null && !other.getMemoryMiB().equals(this.getMemoryMiB())) {
            return false;
        }
        if (other.getOsFamily() == null ^ this.getOsFamily() == null) {
            return false;
        }
        if (other.getOsFamily() != null && !other.getOsFamily().equals(this.getOsFamily())) {
            return false;
        }
        if (other.getVCpuCount() == null ^ this.getVCpuCount() == null) {
            return false;
        }
        return other.getVCpuCount() == null || other.getVCpuCount().equals(this.getVCpuCount());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAcceleratorCount() == null ? 0 : this.getAcceleratorCount().hashCode());
        hashCode = 31 * hashCode + (this.getAcceleratorTotalMemoryMiB() == null ? 0 : this.getAcceleratorTotalMemoryMiB().hashCode());
        hashCode = 31 * hashCode + (this.getAcceleratorTypes() == null ? 0 : this.getAcceleratorTypes().hashCode());
        hashCode = 31 * hashCode + (this.getCpuArchitectureType() == null ? 0 : this.getCpuArchitectureType().hashCode());
        hashCode = 31 * hashCode + (this.getCustomAmounts() == null ? 0 : this.getCustomAmounts().hashCode());
        hashCode = 31 * hashCode + (this.getCustomAttributes() == null ? 0 : this.getCustomAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getMemoryMiB() == null ? 0 : this.getMemoryMiB().hashCode());
        hashCode = 31 * hashCode + (this.getOsFamily() == null ? 0 : this.getOsFamily().hashCode());
        hashCode = 31 * hashCode + (this.getVCpuCount() == null ? 0 : this.getVCpuCount().hashCode());
        return hashCode;
    }

    public CustomerManagedWorkerCapabilities clone() {
        try {
            return (CustomerManagedWorkerCapabilities)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CustomerManagedWorkerCapabilitiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

