/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datasync.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.datasync.model.Capacity;

@SdkInternalApi
public class CapacityMarshaller {
    private static final MarshallingInfo<Long> USED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Used").build();
    private static final MarshallingInfo<Long> PROVISIONED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Provisioned").build();
    private static final MarshallingInfo<Long> LOGICALUSED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogicalUsed").build();
    private static final MarshallingInfo<Long> CLUSTERCLOUDSTORAGEUSED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterCloudStorageUsed").build();
    private static final CapacityMarshaller instance = new CapacityMarshaller();

    public static CapacityMarshaller getInstance() {
        return instance;
    }

    public void marshall(Capacity capacity, ProtocolMarshaller protocolMarshaller) {
        if (capacity == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)capacity.getUsed(), USED_BINDING);
            protocolMarshaller.marshall((Object)capacity.getProvisioned(), PROVISIONED_BINDING);
            protocolMarshaller.marshall((Object)capacity.getLogicalUsed(), LOGICALUSED_BINDING);
            protocolMarshaller.marshall((Object)capacity.getClusterCloudStorageUsed(), CLUSTERCLOUDSTORAGEUSED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

