/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datasync.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.datasync.model.ObjectStorageServerProtocol;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateLocationObjectStorageRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String locationArn;
    private Integer serverPort;
    private String serverProtocol;
    private String subdirectory;
    private String accessKey;
    private String secretKey;
    private List<String> agentArns;
    private ByteBuffer serverCertificate;

    public void setLocationArn(String locationArn) {
        this.locationArn = locationArn;
    }

    public String getLocationArn() {
        return this.locationArn;
    }

    public UpdateLocationObjectStorageRequest withLocationArn(String locationArn) {
        this.setLocationArn(locationArn);
        return this;
    }

    public void setServerPort(Integer serverPort) {
        this.serverPort = serverPort;
    }

    public Integer getServerPort() {
        return this.serverPort;
    }

    public UpdateLocationObjectStorageRequest withServerPort(Integer serverPort) {
        this.setServerPort(serverPort);
        return this;
    }

    public void setServerProtocol(String serverProtocol) {
        this.serverProtocol = serverProtocol;
    }

    public String getServerProtocol() {
        return this.serverProtocol;
    }

    public UpdateLocationObjectStorageRequest withServerProtocol(String serverProtocol) {
        this.setServerProtocol(serverProtocol);
        return this;
    }

    public UpdateLocationObjectStorageRequest withServerProtocol(ObjectStorageServerProtocol serverProtocol) {
        this.serverProtocol = serverProtocol.toString();
        return this;
    }

    public void setSubdirectory(String subdirectory) {
        this.subdirectory = subdirectory;
    }

    public String getSubdirectory() {
        return this.subdirectory;
    }

    public UpdateLocationObjectStorageRequest withSubdirectory(String subdirectory) {
        this.setSubdirectory(subdirectory);
        return this;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public UpdateLocationObjectStorageRequest withAccessKey(String accessKey) {
        this.setAccessKey(accessKey);
        return this;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public UpdateLocationObjectStorageRequest withSecretKey(String secretKey) {
        this.setSecretKey(secretKey);
        return this;
    }

    public List<String> getAgentArns() {
        return this.agentArns;
    }

    public void setAgentArns(Collection<String> agentArns) {
        if (agentArns == null) {
            this.agentArns = null;
            return;
        }
        this.agentArns = new ArrayList<String>(agentArns);
    }

    public UpdateLocationObjectStorageRequest withAgentArns(String ... agentArns) {
        if (this.agentArns == null) {
            this.setAgentArns(new ArrayList<String>(agentArns.length));
        }
        for (String ele : agentArns) {
            this.agentArns.add(ele);
        }
        return this;
    }

    public UpdateLocationObjectStorageRequest withAgentArns(Collection<String> agentArns) {
        this.setAgentArns(agentArns);
        return this;
    }

    public void setServerCertificate(ByteBuffer serverCertificate) {
        this.serverCertificate = serverCertificate;
    }

    public ByteBuffer getServerCertificate() {
        return this.serverCertificate;
    }

    public UpdateLocationObjectStorageRequest withServerCertificate(ByteBuffer serverCertificate) {
        this.setServerCertificate(serverCertificate);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLocationArn() != null) {
            sb.append("LocationArn: ").append(this.getLocationArn()).append(",");
        }
        if (this.getServerPort() != null) {
            sb.append("ServerPort: ").append(this.getServerPort()).append(",");
        }
        if (this.getServerProtocol() != null) {
            sb.append("ServerProtocol: ").append(this.getServerProtocol()).append(",");
        }
        if (this.getSubdirectory() != null) {
            sb.append("Subdirectory: ").append(this.getSubdirectory()).append(",");
        }
        if (this.getAccessKey() != null) {
            sb.append("AccessKey: ").append(this.getAccessKey()).append(",");
        }
        if (this.getSecretKey() != null) {
            sb.append("SecretKey: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getAgentArns() != null) {
            sb.append("AgentArns: ").append(this.getAgentArns()).append(",");
        }
        if (this.getServerCertificate() != null) {
            sb.append("ServerCertificate: ").append(this.getServerCertificate());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLocationObjectStorageRequest)) {
            return false;
        }
        UpdateLocationObjectStorageRequest other = (UpdateLocationObjectStorageRequest)obj;
        if (other.getLocationArn() == null ^ this.getLocationArn() == null) {
            return false;
        }
        if (other.getLocationArn() != null && !other.getLocationArn().equals(this.getLocationArn())) {
            return false;
        }
        if (other.getServerPort() == null ^ this.getServerPort() == null) {
            return false;
        }
        if (other.getServerPort() != null && !other.getServerPort().equals(this.getServerPort())) {
            return false;
        }
        if (other.getServerProtocol() == null ^ this.getServerProtocol() == null) {
            return false;
        }
        if (other.getServerProtocol() != null && !other.getServerProtocol().equals(this.getServerProtocol())) {
            return false;
        }
        if (other.getSubdirectory() == null ^ this.getSubdirectory() == null) {
            return false;
        }
        if (other.getSubdirectory() != null && !other.getSubdirectory().equals(this.getSubdirectory())) {
            return false;
        }
        if (other.getAccessKey() == null ^ this.getAccessKey() == null) {
            return false;
        }
        if (other.getAccessKey() != null && !other.getAccessKey().equals(this.getAccessKey())) {
            return false;
        }
        if (other.getSecretKey() == null ^ this.getSecretKey() == null) {
            return false;
        }
        if (other.getSecretKey() != null && !other.getSecretKey().equals(this.getSecretKey())) {
            return false;
        }
        if (other.getAgentArns() == null ^ this.getAgentArns() == null) {
            return false;
        }
        if (other.getAgentArns() != null && !other.getAgentArns().equals(this.getAgentArns())) {
            return false;
        }
        if (other.getServerCertificate() == null ^ this.getServerCertificate() == null) {
            return false;
        }
        return other.getServerCertificate() == null || other.getServerCertificate().equals(this.getServerCertificate());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLocationArn() == null ? 0 : this.getLocationArn().hashCode());
        hashCode = 31 * hashCode + (this.getServerPort() == null ? 0 : this.getServerPort().hashCode());
        hashCode = 31 * hashCode + (this.getServerProtocol() == null ? 0 : this.getServerProtocol().hashCode());
        hashCode = 31 * hashCode + (this.getSubdirectory() == null ? 0 : this.getSubdirectory().hashCode());
        hashCode = 31 * hashCode + (this.getAccessKey() == null ? 0 : this.getAccessKey().hashCode());
        hashCode = 31 * hashCode + (this.getSecretKey() == null ? 0 : this.getSecretKey().hashCode());
        hashCode = 31 * hashCode + (this.getAgentArns() == null ? 0 : this.getAgentArns().hashCode());
        hashCode = 31 * hashCode + (this.getServerCertificate() == null ? 0 : this.getServerCertificate().hashCode());
        return hashCode;
    }

    public UpdateLocationObjectStorageRequest clone() {
        return (UpdateLocationObjectStorageRequest)super.clone();
    }
}

