/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dataexchange.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.dataexchange.model.transform.S3DataAccessAssetMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class S3DataAccessAsset
implements Serializable,
Cloneable,
StructuredPojo {
    private String bucket;
    private List<String> keyPrefixes;
    private List<String> keys;
    private String s3AccessPointAlias;
    private String s3AccessPointArn;

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getBucket() {
        return this.bucket;
    }

    public S3DataAccessAsset withBucket(String bucket) {
        this.setBucket(bucket);
        return this;
    }

    public List<String> getKeyPrefixes() {
        return this.keyPrefixes;
    }

    public void setKeyPrefixes(Collection<String> keyPrefixes) {
        if (keyPrefixes == null) {
            this.keyPrefixes = null;
            return;
        }
        this.keyPrefixes = new ArrayList<String>(keyPrefixes);
    }

    public S3DataAccessAsset withKeyPrefixes(String ... keyPrefixes) {
        if (this.keyPrefixes == null) {
            this.setKeyPrefixes(new ArrayList<String>(keyPrefixes.length));
        }
        for (String ele : keyPrefixes) {
            this.keyPrefixes.add(ele);
        }
        return this;
    }

    public S3DataAccessAsset withKeyPrefixes(Collection<String> keyPrefixes) {
        this.setKeyPrefixes(keyPrefixes);
        return this;
    }

    public List<String> getKeys() {
        return this.keys;
    }

    public void setKeys(Collection<String> keys) {
        if (keys == null) {
            this.keys = null;
            return;
        }
        this.keys = new ArrayList<String>(keys);
    }

    public S3DataAccessAsset withKeys(String ... keys) {
        if (this.keys == null) {
            this.setKeys(new ArrayList<String>(keys.length));
        }
        for (String ele : keys) {
            this.keys.add(ele);
        }
        return this;
    }

    public S3DataAccessAsset withKeys(Collection<String> keys) {
        this.setKeys(keys);
        return this;
    }

    public void setS3AccessPointAlias(String s3AccessPointAlias) {
        this.s3AccessPointAlias = s3AccessPointAlias;
    }

    public String getS3AccessPointAlias() {
        return this.s3AccessPointAlias;
    }

    public S3DataAccessAsset withS3AccessPointAlias(String s3AccessPointAlias) {
        this.setS3AccessPointAlias(s3AccessPointAlias);
        return this;
    }

    public void setS3AccessPointArn(String s3AccessPointArn) {
        this.s3AccessPointArn = s3AccessPointArn;
    }

    public String getS3AccessPointArn() {
        return this.s3AccessPointArn;
    }

    public S3DataAccessAsset withS3AccessPointArn(String s3AccessPointArn) {
        this.setS3AccessPointArn(s3AccessPointArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBucket() != null) {
            sb.append("Bucket: ").append(this.getBucket()).append(",");
        }
        if (this.getKeyPrefixes() != null) {
            sb.append("KeyPrefixes: ").append(this.getKeyPrefixes()).append(",");
        }
        if (this.getKeys() != null) {
            sb.append("Keys: ").append(this.getKeys()).append(",");
        }
        if (this.getS3AccessPointAlias() != null) {
            sb.append("S3AccessPointAlias: ").append(this.getS3AccessPointAlias()).append(",");
        }
        if (this.getS3AccessPointArn() != null) {
            sb.append("S3AccessPointArn: ").append(this.getS3AccessPointArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DataAccessAsset)) {
            return false;
        }
        S3DataAccessAsset other = (S3DataAccessAsset)obj;
        if (other.getBucket() == null ^ this.getBucket() == null) {
            return false;
        }
        if (other.getBucket() != null && !other.getBucket().equals(this.getBucket())) {
            return false;
        }
        if (other.getKeyPrefixes() == null ^ this.getKeyPrefixes() == null) {
            return false;
        }
        if (other.getKeyPrefixes() != null && !other.getKeyPrefixes().equals(this.getKeyPrefixes())) {
            return false;
        }
        if (other.getKeys() == null ^ this.getKeys() == null) {
            return false;
        }
        if (other.getKeys() != null && !other.getKeys().equals(this.getKeys())) {
            return false;
        }
        if (other.getS3AccessPointAlias() == null ^ this.getS3AccessPointAlias() == null) {
            return false;
        }
        if (other.getS3AccessPointAlias() != null && !other.getS3AccessPointAlias().equals(this.getS3AccessPointAlias())) {
            return false;
        }
        if (other.getS3AccessPointArn() == null ^ this.getS3AccessPointArn() == null) {
            return false;
        }
        return other.getS3AccessPointArn() == null || other.getS3AccessPointArn().equals(this.getS3AccessPointArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBucket() == null ? 0 : this.getBucket().hashCode());
        hashCode = 31 * hashCode + (this.getKeyPrefixes() == null ? 0 : this.getKeyPrefixes().hashCode());
        hashCode = 31 * hashCode + (this.getKeys() == null ? 0 : this.getKeys().hashCode());
        hashCode = 31 * hashCode + (this.getS3AccessPointAlias() == null ? 0 : this.getS3AccessPointAlias().hashCode());
        hashCode = 31 * hashCode + (this.getS3AccessPointArn() == null ? 0 : this.getS3AccessPointArn().hashCode());
        return hashCode;
    }

    public S3DataAccessAsset clone() {
        try {
            return (S3DataAccessAsset)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3DataAccessAssetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

