/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dataexchange;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.dataexchange.AWSDataExchangeAsync;
import com.amazonaws.services.dataexchange.AWSDataExchangeAsyncClientBuilder;
import com.amazonaws.services.dataexchange.AWSDataExchangeClient;
import com.amazonaws.services.dataexchange.model.CancelJobRequest;
import com.amazonaws.services.dataexchange.model.CancelJobResult;
import com.amazonaws.services.dataexchange.model.CreateDataSetRequest;
import com.amazonaws.services.dataexchange.model.CreateDataSetResult;
import com.amazonaws.services.dataexchange.model.CreateJobRequest;
import com.amazonaws.services.dataexchange.model.CreateJobResult;
import com.amazonaws.services.dataexchange.model.CreateRevisionRequest;
import com.amazonaws.services.dataexchange.model.CreateRevisionResult;
import com.amazonaws.services.dataexchange.model.DeleteAssetRequest;
import com.amazonaws.services.dataexchange.model.DeleteAssetResult;
import com.amazonaws.services.dataexchange.model.DeleteDataSetRequest;
import com.amazonaws.services.dataexchange.model.DeleteDataSetResult;
import com.amazonaws.services.dataexchange.model.DeleteRevisionRequest;
import com.amazonaws.services.dataexchange.model.DeleteRevisionResult;
import com.amazonaws.services.dataexchange.model.GetAssetRequest;
import com.amazonaws.services.dataexchange.model.GetAssetResult;
import com.amazonaws.services.dataexchange.model.GetDataSetRequest;
import com.amazonaws.services.dataexchange.model.GetDataSetResult;
import com.amazonaws.services.dataexchange.model.GetJobRequest;
import com.amazonaws.services.dataexchange.model.GetJobResult;
import com.amazonaws.services.dataexchange.model.GetRevisionRequest;
import com.amazonaws.services.dataexchange.model.GetRevisionResult;
import com.amazonaws.services.dataexchange.model.ListDataSetRevisionsRequest;
import com.amazonaws.services.dataexchange.model.ListDataSetRevisionsResult;
import com.amazonaws.services.dataexchange.model.ListDataSetsRequest;
import com.amazonaws.services.dataexchange.model.ListDataSetsResult;
import com.amazonaws.services.dataexchange.model.ListJobsRequest;
import com.amazonaws.services.dataexchange.model.ListJobsResult;
import com.amazonaws.services.dataexchange.model.ListRevisionAssetsRequest;
import com.amazonaws.services.dataexchange.model.ListRevisionAssetsResult;
import com.amazonaws.services.dataexchange.model.ListTagsForResourceRequest;
import com.amazonaws.services.dataexchange.model.ListTagsForResourceResult;
import com.amazonaws.services.dataexchange.model.StartJobRequest;
import com.amazonaws.services.dataexchange.model.StartJobResult;
import com.amazonaws.services.dataexchange.model.TagResourceRequest;
import com.amazonaws.services.dataexchange.model.TagResourceResult;
import com.amazonaws.services.dataexchange.model.UntagResourceRequest;
import com.amazonaws.services.dataexchange.model.UntagResourceResult;
import com.amazonaws.services.dataexchange.model.UpdateAssetRequest;
import com.amazonaws.services.dataexchange.model.UpdateAssetResult;
import com.amazonaws.services.dataexchange.model.UpdateDataSetRequest;
import com.amazonaws.services.dataexchange.model.UpdateDataSetResult;
import com.amazonaws.services.dataexchange.model.UpdateRevisionRequest;
import com.amazonaws.services.dataexchange.model.UpdateRevisionResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSDataExchangeAsyncClient
extends AWSDataExchangeClient
implements AWSDataExchangeAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSDataExchangeAsyncClientBuilder asyncBuilder() {
        return AWSDataExchangeAsyncClientBuilder.standard();
    }

    AWSDataExchangeAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSDataExchangeAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CancelJobResult> cancelJobAsync(CancelJobRequest request) {
        return this.cancelJobAsync(request, null);
    }

    @Override
    public Future<CancelJobResult> cancelJobAsync(CancelJobRequest request, final AsyncHandler<CancelJobRequest, CancelJobResult> asyncHandler) {
        final CancelJobRequest finalRequest = (CancelJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelJobResult>(){

            @Override
            public CancelJobResult call() throws Exception {
                CancelJobResult result = null;
                try {
                    result = AWSDataExchangeAsyncClient.this.executeCancelJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDataSetResult> createDataSetAsync(CreateDataSetRequest request) {
        return this.createDataSetAsync(request, null);
    }

    @Override
    public Future<CreateDataSetResult> createDataSetAsync(CreateDataSetRequest request, final AsyncHandler<CreateDataSetRequest, CreateDataSetResult> asyncHandler) {
        final CreateDataSetRequest finalRequest = (CreateDataSetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDataSetResult>(){

            @Override
            public CreateDataSetResult call() throws Exception {
                CreateDataSetResult result = null;
                try {
                    result = AWSDataExchangeAsyncClient.this.executeCreateDataSet(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateJobResult> createJobAsync(CreateJobRequest request) {
        return this.createJobAsync(request, null);
    }

    @Override
    public Future<CreateJobResult> createJobAsync(CreateJobRequest request, final AsyncHandler<CreateJobRequest, CreateJobResult> asyncHandler) {
        final CreateJobRequest finalRequest = (CreateJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateJobResult>(){

            @Override
            public CreateJobResult call() throws Exception {
                CreateJobResult result = null;
                try {
                    result = AWSDataExchangeAsyncClient.this.executeCreateJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateRevisionResult> createRevisionAsync(CreateRevisionRequest request) {
        return this.createRevisionAsync(request, null);
    }

    @Override
    public Future<CreateRevisionResult> createRevisionAsync(CreateRevisionRequest request, final AsyncHandler<CreateRevisionRequest, CreateRevisionResult> asyncHandler) {
        final CreateRevisionRequest finalRequest = (CreateRevisionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateRevisionResult>(){

            @Override
            public CreateRevisionResult call() throws Exception {
                CreateRevisionResult result = null;
                try {
                    result = AWSDataExchangeAsyncClient.this.executeCreateRevision(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAssetResult> deleteAssetAsync(DeleteAssetRequest request) {
        return this.deleteAssetAsync(request, null);
    }

    @Override
    public Future<DeleteAssetResult> deleteAssetAsync(DeleteAssetRequest request, final AsyncHandler<DeleteAssetRequest, DeleteAssetResult> asyncHandler) {
        final DeleteAssetRequest finalRequest = (DeleteAssetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteAssetResult>(){

            @Override
            public DeleteAssetResult call() throws Exception {
                DeleteAssetResult result = null;
                try {
                    result = AWSDataExchangeAsyncClient.this.executeDeleteAsset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDataSetResult> deleteDataSetAsync(DeleteDataSetRequest request) {
        return this.deleteDataSetAsync(request, null);
    }

    @Override
    public Future<DeleteDataSetResult> deleteDataSetAsync(DeleteDataSetRequest request, final AsyncHandler<DeleteDataSetRequest, DeleteDataSetResult> asyncHandler) {
        final DeleteDataSetRequest finalRequest = (DeleteDataSetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDataSetResult>(){

            @Override
            public DeleteDataSetResult call() throws Exception {
                DeleteDataSetResult result = null;
                try {
                    result = AWSDataExchangeAsyncClient.this.executeDeleteDataSet(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteRevisionResult> deleteRevisionAsync(DeleteRevisionRequest request) {
        return this.deleteRevisionAsync(request, null);
    }

    @Override
    public Future<DeleteRevisionResult> deleteRevisionAsync(DeleteRevisionRequest request, final AsyncHandler<DeleteRevisionRequest, DeleteRevisionResult> asyncHandler) {
        final DeleteRevisionRequest finalRequest = (DeleteRevisionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteRevisionResult>(){

            @Override
            public DeleteRevisionResult call() throws Exception {
                DeleteRevisionResult result = null;
                try {
                    result = AWSDataExchangeAsyncClient.this.executeDeleteRevision(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAssetResult> getAssetAsync(GetAssetRequest request) {
        return this.getAssetAsync(request, null);
    }

    @Override
    public Future<GetAssetResult> getAssetAsync(GetAssetRequest request, final AsyncHandler<GetAssetRequest, GetAssetResult> asyncHandler) {
        final GetAssetRequest finalRequest = (GetAssetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAssetResult>(){

            @Override
            public GetAssetResult call() throws Exception {
                GetAssetResult result = null;
                try {
                    result = AWSDataExchangeAsyncClient.this.executeGetAsset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDataSetResult> getDataSetAsync(GetDataSetRequest request) {
        return this.getDataSetAsync(request, null);
    }

    @Override
    public Future<GetDataSetResult> getDataSetAsync(GetDataSetRequest request, final AsyncHandler<GetDataSetRequest, GetDataSetResult> asyncHandler) {
        final GetDataSetRequest finalRequest = (GetDataSetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDataSetResult>(){

            @Override
            public GetDataSetResult call() throws Exception {
                GetDataSetResult result = null;
                try {
                    result = AWSDataExchangeAsyncClient.this.executeGetDataSet(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetJobResult> getJobAsync(GetJobRequest request) {
        return this.getJobAsync(request, null);
    }

    @Override
    public Future<GetJobResult> getJobAsync(GetJobRequest request, final AsyncHandler<GetJobRequest, GetJobResult> asyncHandler) {
        final GetJobRequest finalRequest = (GetJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetJobResult>(){

            @Override
            public GetJobResult call() throws Exception {
                GetJobResult result = null;
                try {
                    result = AWSDataExchangeAsyncClient.this.executeGetJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRevisionResult> getRevisionAsync(GetRevisionRequest request) {
        return this.getRevisionAsync(request, null);
    }

    @Override
    public Future<GetRevisionResult> getRevisionAsync(GetRevisionRequest request, final AsyncHandler<GetRevisionRequest, GetRevisionResult> asyncHandler) {
        final GetRevisionRequest finalRequest = (GetRevisionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetRevisionResult>(){

            @Override
            public GetRevisionResult call() throws Exception {
                GetRevisionResult result = null;
                try {
                    result = AWSDataExchangeAsyncClient.this.executeGetRevision(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDataSetRevisionsResult> listDataSetRevisionsAsync(ListDataSetRevisionsRequest request) {
        return this.listDataSetRevisionsAsync(request, null);
    }

    @Override
    public Future<ListDataSetRevisionsResult> listDataSetRevisionsAsync(ListDataSetRevisionsRequest request, final AsyncHandler<ListDataSetRevisionsRequest, ListDataSetRevisionsResult> asyncHandler) {
        final ListDataSetRevisionsRequest finalRequest = (ListDataSetRevisionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDataSetRevisionsResult>(){

            @Override
            public ListDataSetRevisionsResult call() throws Exception {
                ListDataSetRevisionsResult result = null;
                try {
                    result = AWSDataExchangeAsyncClient.this.executeListDataSetRevisions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDataSetsResult> listDataSetsAsync(ListDataSetsRequest request) {
        return this.listDataSetsAsync(request, null);
    }

    @Override
    public Future<ListDataSetsResult> listDataSetsAsync(ListDataSetsRequest request, final AsyncHandler<ListDataSetsRequest, ListDataSetsResult> asyncHandler) {
        final ListDataSetsRequest finalRequest = (ListDataSetsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDataSetsResult>(){

            @Override
            public ListDataSetsResult call() throws Exception {
                ListDataSetsResult result = null;
                try {
                    result = AWSDataExchangeAsyncClient.this.executeListDataSets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListJobsResult> listJobsAsync(ListJobsRequest request) {
        return this.listJobsAsync(request, null);
    }

    @Override
    public Future<ListJobsResult> listJobsAsync(ListJobsRequest request, final AsyncHandler<ListJobsRequest, ListJobsResult> asyncHandler) {
        final ListJobsRequest finalRequest = (ListJobsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListJobsResult>(){

            @Override
            public ListJobsResult call() throws Exception {
                ListJobsResult result = null;
                try {
                    result = AWSDataExchangeAsyncClient.this.executeListJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRevisionAssetsResult> listRevisionAssetsAsync(ListRevisionAssetsRequest request) {
        return this.listRevisionAssetsAsync(request, null);
    }

    @Override
    public Future<ListRevisionAssetsResult> listRevisionAssetsAsync(ListRevisionAssetsRequest request, final AsyncHandler<ListRevisionAssetsRequest, ListRevisionAssetsResult> asyncHandler) {
        final ListRevisionAssetsRequest finalRequest = (ListRevisionAssetsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListRevisionAssetsResult>(){

            @Override
            public ListRevisionAssetsResult call() throws Exception {
                ListRevisionAssetsResult result = null;
                try {
                    result = AWSDataExchangeAsyncClient.this.executeListRevisionAssets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSDataExchangeAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartJobResult> startJobAsync(StartJobRequest request) {
        return this.startJobAsync(request, null);
    }

    @Override
    public Future<StartJobResult> startJobAsync(StartJobRequest request, final AsyncHandler<StartJobRequest, StartJobResult> asyncHandler) {
        final StartJobRequest finalRequest = (StartJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartJobResult>(){

            @Override
            public StartJobResult call() throws Exception {
                StartJobResult result = null;
                try {
                    result = AWSDataExchangeAsyncClient.this.executeStartJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSDataExchangeAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSDataExchangeAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateAssetResult> updateAssetAsync(UpdateAssetRequest request) {
        return this.updateAssetAsync(request, null);
    }

    @Override
    public Future<UpdateAssetResult> updateAssetAsync(UpdateAssetRequest request, final AsyncHandler<UpdateAssetRequest, UpdateAssetResult> asyncHandler) {
        final UpdateAssetRequest finalRequest = (UpdateAssetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateAssetResult>(){

            @Override
            public UpdateAssetResult call() throws Exception {
                UpdateAssetResult result = null;
                try {
                    result = AWSDataExchangeAsyncClient.this.executeUpdateAsset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDataSetResult> updateDataSetAsync(UpdateDataSetRequest request) {
        return this.updateDataSetAsync(request, null);
    }

    @Override
    public Future<UpdateDataSetResult> updateDataSetAsync(UpdateDataSetRequest request, final AsyncHandler<UpdateDataSetRequest, UpdateDataSetResult> asyncHandler) {
        final UpdateDataSetRequest finalRequest = (UpdateDataSetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateDataSetResult>(){

            @Override
            public UpdateDataSetResult call() throws Exception {
                UpdateDataSetResult result = null;
                try {
                    result = AWSDataExchangeAsyncClient.this.executeUpdateDataSet(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateRevisionResult> updateRevisionAsync(UpdateRevisionRequest request) {
        return this.updateRevisionAsync(request, null);
    }

    @Override
    public Future<UpdateRevisionResult> updateRevisionAsync(UpdateRevisionRequest request, final AsyncHandler<UpdateRevisionRequest, UpdateRevisionResult> asyncHandler) {
        final UpdateRevisionRequest finalRequest = (UpdateRevisionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateRevisionResult>(){

            @Override
            public UpdateRevisionResult call() throws Exception {
                UpdateRevisionResult result = null;
                try {
                    result = AWSDataExchangeAsyncClient.this.executeUpdateRevision(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

