/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.costexplorer.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.costexplorer.model.DateInterval;
import com.amazonaws.services.costexplorer.model.Expression;
import com.amazonaws.services.costexplorer.model.SortDefinition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetCostCategoriesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String searchString;
    private DateInterval timePeriod;
    private String costCategoryName;
    private Expression filter;
    private List<SortDefinition> sortBy;
    private Integer maxResults;
    private String nextPageToken;

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public GetCostCategoriesRequest withSearchString(String searchString) {
        this.setSearchString(searchString);
        return this;
    }

    public void setTimePeriod(DateInterval timePeriod) {
        this.timePeriod = timePeriod;
    }

    public DateInterval getTimePeriod() {
        return this.timePeriod;
    }

    public GetCostCategoriesRequest withTimePeriod(DateInterval timePeriod) {
        this.setTimePeriod(timePeriod);
        return this;
    }

    public void setCostCategoryName(String costCategoryName) {
        this.costCategoryName = costCategoryName;
    }

    public String getCostCategoryName() {
        return this.costCategoryName;
    }

    public GetCostCategoriesRequest withCostCategoryName(String costCategoryName) {
        this.setCostCategoryName(costCategoryName);
        return this;
    }

    public void setFilter(Expression filter) {
        this.filter = filter;
    }

    public Expression getFilter() {
        return this.filter;
    }

    public GetCostCategoriesRequest withFilter(Expression filter) {
        this.setFilter(filter);
        return this;
    }

    public List<SortDefinition> getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(Collection<SortDefinition> sortBy) {
        if (sortBy == null) {
            this.sortBy = null;
            return;
        }
        this.sortBy = new ArrayList<SortDefinition>(sortBy);
    }

    public GetCostCategoriesRequest withSortBy(SortDefinition ... sortBy) {
        if (this.sortBy == null) {
            this.setSortBy(new ArrayList<SortDefinition>(sortBy.length));
        }
        for (SortDefinition ele : sortBy) {
            this.sortBy.add(ele);
        }
        return this;
    }

    public GetCostCategoriesRequest withSortBy(Collection<SortDefinition> sortBy) {
        this.setSortBy(sortBy);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public GetCostCategoriesRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public GetCostCategoriesRequest withNextPageToken(String nextPageToken) {
        this.setNextPageToken(nextPageToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSearchString() != null) {
            sb.append("SearchString: ").append(this.getSearchString()).append(",");
        }
        if (this.getTimePeriod() != null) {
            sb.append("TimePeriod: ").append(this.getTimePeriod()).append(",");
        }
        if (this.getCostCategoryName() != null) {
            sb.append("CostCategoryName: ").append(this.getCostCategoryName()).append(",");
        }
        if (this.getFilter() != null) {
            sb.append("Filter: ").append(this.getFilter()).append(",");
        }
        if (this.getSortBy() != null) {
            sb.append("SortBy: ").append(this.getSortBy()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.getNextPageToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCostCategoriesRequest)) {
            return false;
        }
        GetCostCategoriesRequest other = (GetCostCategoriesRequest)obj;
        if (other.getSearchString() == null ^ this.getSearchString() == null) {
            return false;
        }
        if (other.getSearchString() != null && !other.getSearchString().equals(this.getSearchString())) {
            return false;
        }
        if (other.getTimePeriod() == null ^ this.getTimePeriod() == null) {
            return false;
        }
        if (other.getTimePeriod() != null && !other.getTimePeriod().equals(this.getTimePeriod())) {
            return false;
        }
        if (other.getCostCategoryName() == null ^ this.getCostCategoryName() == null) {
            return false;
        }
        if (other.getCostCategoryName() != null && !other.getCostCategoryName().equals(this.getCostCategoryName())) {
            return false;
        }
        if (other.getFilter() == null ^ this.getFilter() == null) {
            return false;
        }
        if (other.getFilter() != null && !other.getFilter().equals(this.getFilter())) {
            return false;
        }
        if (other.getSortBy() == null ^ this.getSortBy() == null) {
            return false;
        }
        if (other.getSortBy() != null && !other.getSortBy().equals(this.getSortBy())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextPageToken() == null ^ this.getNextPageToken() == null) {
            return false;
        }
        return other.getNextPageToken() == null || other.getNextPageToken().equals(this.getNextPageToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSearchString() == null ? 0 : this.getSearchString().hashCode());
        hashCode = 31 * hashCode + (this.getTimePeriod() == null ? 0 : this.getTimePeriod().hashCode());
        hashCode = 31 * hashCode + (this.getCostCategoryName() == null ? 0 : this.getCostCategoryName().hashCode());
        hashCode = 31 * hashCode + (this.getFilter() == null ? 0 : this.getFilter().hashCode());
        hashCode = 31 * hashCode + (this.getSortBy() == null ? 0 : this.getSortBy().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextPageToken() == null ? 0 : this.getNextPageToken().hashCode());
        return hashCode;
    }

    public GetCostCategoriesRequest clone() {
        return (GetCostCategoriesRequest)super.clone();
    }
}

