/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.controltower.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.controltower.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * EnabledControlDetailsMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class EnabledControlDetailsMarshaller {

    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("arn").build();
    private static final MarshallingInfo<String> CONTROLIDENTIFIER_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("controlIdentifier").build();
    private static final MarshallingInfo<StructuredPojo> DRIFTSTATUSSUMMARY_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("driftStatusSummary").build();
    private static final MarshallingInfo<StructuredPojo> STATUSSUMMARY_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusSummary").build();
    private static final MarshallingInfo<String> TARGETIDENTIFIER_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targetIdentifier").build();
    private static final MarshallingInfo<List> TARGETREGIONS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("targetRegions").build();

    private static final EnabledControlDetailsMarshaller instance = new EnabledControlDetailsMarshaller();

    public static EnabledControlDetailsMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(EnabledControlDetails enabledControlDetails, ProtocolMarshaller protocolMarshaller) {

        if (enabledControlDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(enabledControlDetails.getArn(), ARN_BINDING);
            protocolMarshaller.marshall(enabledControlDetails.getControlIdentifier(), CONTROLIDENTIFIER_BINDING);
            protocolMarshaller.marshall(enabledControlDetails.getDriftStatusSummary(), DRIFTSTATUSSUMMARY_BINDING);
            protocolMarshaller.marshall(enabledControlDetails.getStatusSummary(), STATUSSUMMARY_BINDING);
            protocolMarshaller.marshall(enabledControlDetails.getTargetIdentifier(), TARGETIDENTIFIER_BINDING);
            protocolMarshaller.marshall(enabledControlDetails.getTargetRegions(), TARGETREGIONS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
