/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connect.model.EncryptionConfig;
import com.amazonaws.services.connect.model.transform.S3ConfigMarshaller;
import java.io.Serializable;

public class S3Config
implements Serializable,
Cloneable,
StructuredPojo {
    private String bucketName;
    private String bucketPrefix;
    private EncryptionConfig encryptionConfig;

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public S3Config withBucketName(String bucketName) {
        this.setBucketName(bucketName);
        return this;
    }

    public void setBucketPrefix(String bucketPrefix) {
        this.bucketPrefix = bucketPrefix;
    }

    public String getBucketPrefix() {
        return this.bucketPrefix;
    }

    public S3Config withBucketPrefix(String bucketPrefix) {
        this.setBucketPrefix(bucketPrefix);
        return this;
    }

    public void setEncryptionConfig(EncryptionConfig encryptionConfig) {
        this.encryptionConfig = encryptionConfig;
    }

    public EncryptionConfig getEncryptionConfig() {
        return this.encryptionConfig;
    }

    public S3Config withEncryptionConfig(EncryptionConfig encryptionConfig) {
        this.setEncryptionConfig(encryptionConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBucketName() != null) {
            sb.append("BucketName: ").append(this.getBucketName()).append(",");
        }
        if (this.getBucketPrefix() != null) {
            sb.append("BucketPrefix: ").append(this.getBucketPrefix()).append(",");
        }
        if (this.getEncryptionConfig() != null) {
            sb.append("EncryptionConfig: ").append(this.getEncryptionConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Config)) {
            return false;
        }
        S3Config other = (S3Config)obj;
        if (other.getBucketName() == null ^ this.getBucketName() == null) {
            return false;
        }
        if (other.getBucketName() != null && !other.getBucketName().equals(this.getBucketName())) {
            return false;
        }
        if (other.getBucketPrefix() == null ^ this.getBucketPrefix() == null) {
            return false;
        }
        if (other.getBucketPrefix() != null && !other.getBucketPrefix().equals(this.getBucketPrefix())) {
            return false;
        }
        if (other.getEncryptionConfig() == null ^ this.getEncryptionConfig() == null) {
            return false;
        }
        return other.getEncryptionConfig() == null || other.getEncryptionConfig().equals(this.getEncryptionConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBucketName() == null ? 0 : this.getBucketName().hashCode());
        hashCode = 31 * hashCode + (this.getBucketPrefix() == null ? 0 : this.getBucketPrefix().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionConfig() == null ? 0 : this.getEncryptionConfig().hashCode());
        return hashCode;
    }

    public S3Config clone() {
        try {
            return (S3Config)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3ConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

