/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.connect.model.ContactFlowType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListContactFlowsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String instanceId;
    private List<String> contactFlowTypes;
    private String nextToken;
    private Integer maxResults;

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public ListContactFlowsRequest withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public List<String> getContactFlowTypes() {
        return this.contactFlowTypes;
    }

    public void setContactFlowTypes(Collection<String> contactFlowTypes) {
        if (contactFlowTypes == null) {
            this.contactFlowTypes = null;
            return;
        }
        this.contactFlowTypes = new ArrayList<String>(contactFlowTypes);
    }

    public ListContactFlowsRequest withContactFlowTypes(String ... contactFlowTypes) {
        if (this.contactFlowTypes == null) {
            this.setContactFlowTypes(new ArrayList<String>(contactFlowTypes.length));
        }
        for (String ele : contactFlowTypes) {
            this.contactFlowTypes.add(ele);
        }
        return this;
    }

    public ListContactFlowsRequest withContactFlowTypes(Collection<String> contactFlowTypes) {
        this.setContactFlowTypes(contactFlowTypes);
        return this;
    }

    public ListContactFlowsRequest withContactFlowTypes(ContactFlowType ... contactFlowTypes) {
        ArrayList<String> contactFlowTypesCopy = new ArrayList<String>(contactFlowTypes.length);
        for (ContactFlowType value : contactFlowTypes) {
            contactFlowTypesCopy.add(value.toString());
        }
        if (this.getContactFlowTypes() == null) {
            this.setContactFlowTypes(contactFlowTypesCopy);
        } else {
            this.getContactFlowTypes().addAll(contactFlowTypesCopy);
        }
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListContactFlowsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListContactFlowsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: ").append(this.getInstanceId()).append(",");
        }
        if (this.getContactFlowTypes() != null) {
            sb.append("ContactFlowTypes: ").append(this.getContactFlowTypes()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContactFlowsRequest)) {
            return false;
        }
        ListContactFlowsRequest other = (ListContactFlowsRequest)obj;
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getContactFlowTypes() == null ^ this.getContactFlowTypes() == null) {
            return false;
        }
        if (other.getContactFlowTypes() != null && !other.getContactFlowTypes().equals(this.getContactFlowTypes())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        return other.getMaxResults() == null || other.getMaxResults().equals(this.getMaxResults());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getContactFlowTypes() == null ? 0 : this.getContactFlowTypes().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        return hashCode;
    }

    public ListContactFlowsRequest clone() {
        return (ListContactFlowsRequest)super.clone();
    }
}

