/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.connect.model.RuleAction;
import com.amazonaws.services.connect.model.RulePublishStatus;
import com.amazonaws.services.connect.model.RuleTriggerEventSource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateRuleRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String instanceId;
    private String name;
    private RuleTriggerEventSource triggerEventSource;
    private String function;
    private List<RuleAction> actions;
    private String publishStatus;
    private String clientToken;

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public CreateRuleRequest withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateRuleRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setTriggerEventSource(RuleTriggerEventSource triggerEventSource) {
        this.triggerEventSource = triggerEventSource;
    }

    public RuleTriggerEventSource getTriggerEventSource() {
        return this.triggerEventSource;
    }

    public CreateRuleRequest withTriggerEventSource(RuleTriggerEventSource triggerEventSource) {
        this.setTriggerEventSource(triggerEventSource);
        return this;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public String getFunction() {
        return this.function;
    }

    public CreateRuleRequest withFunction(String function) {
        this.setFunction(function);
        return this;
    }

    public List<RuleAction> getActions() {
        return this.actions;
    }

    public void setActions(Collection<RuleAction> actions) {
        if (actions == null) {
            this.actions = null;
            return;
        }
        this.actions = new ArrayList<RuleAction>(actions);
    }

    public CreateRuleRequest withActions(RuleAction ... actions) {
        if (this.actions == null) {
            this.setActions(new ArrayList<RuleAction>(actions.length));
        }
        for (RuleAction ele : actions) {
            this.actions.add(ele);
        }
        return this;
    }

    public CreateRuleRequest withActions(Collection<RuleAction> actions) {
        this.setActions(actions);
        return this;
    }

    public void setPublishStatus(String publishStatus) {
        this.publishStatus = publishStatus;
    }

    public String getPublishStatus() {
        return this.publishStatus;
    }

    public CreateRuleRequest withPublishStatus(String publishStatus) {
        this.setPublishStatus(publishStatus);
        return this;
    }

    public CreateRuleRequest withPublishStatus(RulePublishStatus publishStatus) {
        this.publishStatus = publishStatus.toString();
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateRuleRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: ").append(this.getInstanceId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getTriggerEventSource() != null) {
            sb.append("TriggerEventSource: ").append(this.getTriggerEventSource()).append(",");
        }
        if (this.getFunction() != null) {
            sb.append("Function: ").append(this.getFunction()).append(",");
        }
        if (this.getActions() != null) {
            sb.append("Actions: ").append(this.getActions()).append(",");
        }
        if (this.getPublishStatus() != null) {
            sb.append("PublishStatus: ").append(this.getPublishStatus()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRuleRequest)) {
            return false;
        }
        CreateRuleRequest other = (CreateRuleRequest)obj;
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getTriggerEventSource() == null ^ this.getTriggerEventSource() == null) {
            return false;
        }
        if (other.getTriggerEventSource() != null && !other.getTriggerEventSource().equals(this.getTriggerEventSource())) {
            return false;
        }
        if (other.getFunction() == null ^ this.getFunction() == null) {
            return false;
        }
        if (other.getFunction() != null && !other.getFunction().equals(this.getFunction())) {
            return false;
        }
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        if (other.getActions() != null && !other.getActions().equals(this.getActions())) {
            return false;
        }
        if (other.getPublishStatus() == null ^ this.getPublishStatus() == null) {
            return false;
        }
        if (other.getPublishStatus() != null && !other.getPublishStatus().equals(this.getPublishStatus())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        return other.getClientToken() == null || other.getClientToken().equals(this.getClientToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getTriggerEventSource() == null ? 0 : this.getTriggerEventSource().hashCode());
        hashCode = 31 * hashCode + (this.getFunction() == null ? 0 : this.getFunction().hashCode());
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        hashCode = 31 * hashCode + (this.getPublishStatus() == null ? 0 : this.getPublishStatus().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        return hashCode;
    }

    public CreateRuleRequest clone() {
        return (CreateRuleRequest)super.clone();
    }
}

