/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.comprehend.model.PiiEntitiesDetectionMaskMode;
import com.amazonaws.services.comprehend.model.PiiEntityType;
import com.amazonaws.services.comprehend.model.transform.RedactionConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RedactionConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> piiEntityTypes;
    private String maskMode;
    private String maskCharacter;

    public List<String> getPiiEntityTypes() {
        return this.piiEntityTypes;
    }

    public void setPiiEntityTypes(Collection<String> piiEntityTypes) {
        if (piiEntityTypes == null) {
            this.piiEntityTypes = null;
            return;
        }
        this.piiEntityTypes = new ArrayList<String>(piiEntityTypes);
    }

    public RedactionConfig withPiiEntityTypes(String ... piiEntityTypes) {
        if (this.piiEntityTypes == null) {
            this.setPiiEntityTypes(new ArrayList<String>(piiEntityTypes.length));
        }
        for (String ele : piiEntityTypes) {
            this.piiEntityTypes.add(ele);
        }
        return this;
    }

    public RedactionConfig withPiiEntityTypes(Collection<String> piiEntityTypes) {
        this.setPiiEntityTypes(piiEntityTypes);
        return this;
    }

    public RedactionConfig withPiiEntityTypes(PiiEntityType ... piiEntityTypes) {
        ArrayList<String> piiEntityTypesCopy = new ArrayList<String>(piiEntityTypes.length);
        for (PiiEntityType value : piiEntityTypes) {
            piiEntityTypesCopy.add(value.toString());
        }
        if (this.getPiiEntityTypes() == null) {
            this.setPiiEntityTypes(piiEntityTypesCopy);
        } else {
            this.getPiiEntityTypes().addAll(piiEntityTypesCopy);
        }
        return this;
    }

    public void setMaskMode(String maskMode) {
        this.maskMode = maskMode;
    }

    public String getMaskMode() {
        return this.maskMode;
    }

    public RedactionConfig withMaskMode(String maskMode) {
        this.setMaskMode(maskMode);
        return this;
    }

    public RedactionConfig withMaskMode(PiiEntitiesDetectionMaskMode maskMode) {
        this.maskMode = maskMode.toString();
        return this;
    }

    public void setMaskCharacter(String maskCharacter) {
        this.maskCharacter = maskCharacter;
    }

    public String getMaskCharacter() {
        return this.maskCharacter;
    }

    public RedactionConfig withMaskCharacter(String maskCharacter) {
        this.setMaskCharacter(maskCharacter);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPiiEntityTypes() != null) {
            sb.append("PiiEntityTypes: ").append(this.getPiiEntityTypes()).append(",");
        }
        if (this.getMaskMode() != null) {
            sb.append("MaskMode: ").append(this.getMaskMode()).append(",");
        }
        if (this.getMaskCharacter() != null) {
            sb.append("MaskCharacter: ").append(this.getMaskCharacter());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedactionConfig)) {
            return false;
        }
        RedactionConfig other = (RedactionConfig)obj;
        if (other.getPiiEntityTypes() == null ^ this.getPiiEntityTypes() == null) {
            return false;
        }
        if (other.getPiiEntityTypes() != null && !other.getPiiEntityTypes().equals(this.getPiiEntityTypes())) {
            return false;
        }
        if (other.getMaskMode() == null ^ this.getMaskMode() == null) {
            return false;
        }
        if (other.getMaskMode() != null && !other.getMaskMode().equals(this.getMaskMode())) {
            return false;
        }
        if (other.getMaskCharacter() == null ^ this.getMaskCharacter() == null) {
            return false;
        }
        return other.getMaskCharacter() == null || other.getMaskCharacter().equals(this.getMaskCharacter());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPiiEntityTypes() == null ? 0 : this.getPiiEntityTypes().hashCode());
        hashCode = 31 * hashCode + (this.getMaskMode() == null ? 0 : this.getMaskMode().hashCode());
        hashCode = 31 * hashCode + (this.getMaskCharacter() == null ? 0 : this.getMaskCharacter().hashCode());
        return hashCode;
    }

    public RedactionConfig clone() {
        try {
            return (RedactionConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RedactionConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

