/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.comprehend.model.DominantLanguage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DetectDominantLanguageResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<DominantLanguage> languages;

    public List<DominantLanguage> getLanguages() {
        return this.languages;
    }

    public void setLanguages(Collection<DominantLanguage> languages) {
        if (languages == null) {
            this.languages = null;
            return;
        }
        this.languages = new ArrayList<DominantLanguage>(languages);
    }

    public DetectDominantLanguageResult withLanguages(DominantLanguage ... languages) {
        if (this.languages == null) {
            this.setLanguages(new ArrayList<DominantLanguage>(languages.length));
        }
        for (DominantLanguage ele : languages) {
            this.languages.add(ele);
        }
        return this;
    }

    public DetectDominantLanguageResult withLanguages(Collection<DominantLanguage> languages) {
        this.setLanguages(languages);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLanguages() != null) {
            sb.append("Languages: ").append(this.getLanguages());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectDominantLanguageResult)) {
            return false;
        }
        DetectDominantLanguageResult other = (DetectDominantLanguageResult)obj;
        if (other.getLanguages() == null ^ this.getLanguages() == null) {
            return false;
        }
        return other.getLanguages() == null || other.getLanguages().equals(this.getLanguages());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLanguages() == null ? 0 : this.getLanguages().hashCode());
        return hashCode;
    }

    public DetectDominantLanguageResult clone() {
        try {
            return (DetectDominantLanguageResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

