/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codegurusecurity.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codegurusecurity.model.CodeLine;
import com.amazonaws.services.codegurusecurity.model.transform.FilePathMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FilePath
implements Serializable,
Cloneable,
StructuredPojo {
    private List<CodeLine> codeSnippet;
    private Integer endLine;
    private String name;
    private String path;
    private Integer startLine;

    public List<CodeLine> getCodeSnippet() {
        return this.codeSnippet;
    }

    public void setCodeSnippet(Collection<CodeLine> codeSnippet) {
        if (codeSnippet == null) {
            this.codeSnippet = null;
            return;
        }
        this.codeSnippet = new ArrayList<CodeLine>(codeSnippet);
    }

    public FilePath withCodeSnippet(CodeLine ... codeSnippet) {
        if (this.codeSnippet == null) {
            this.setCodeSnippet(new ArrayList<CodeLine>(codeSnippet.length));
        }
        for (CodeLine ele : codeSnippet) {
            this.codeSnippet.add(ele);
        }
        return this;
    }

    public FilePath withCodeSnippet(Collection<CodeLine> codeSnippet) {
        this.setCodeSnippet(codeSnippet);
        return this;
    }

    public void setEndLine(Integer endLine) {
        this.endLine = endLine;
    }

    public Integer getEndLine() {
        return this.endLine;
    }

    public FilePath withEndLine(Integer endLine) {
        this.setEndLine(endLine);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public FilePath withName(String name) {
        this.setName(name);
        return this;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public FilePath withPath(String path) {
        this.setPath(path);
        return this;
    }

    public void setStartLine(Integer startLine) {
        this.startLine = startLine;
    }

    public Integer getStartLine() {
        return this.startLine;
    }

    public FilePath withStartLine(Integer startLine) {
        this.setStartLine(startLine);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCodeSnippet() != null) {
            sb.append("CodeSnippet: ").append(this.getCodeSnippet()).append(",");
        }
        if (this.getEndLine() != null) {
            sb.append("EndLine: ").append(this.getEndLine()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getPath() != null) {
            sb.append("Path: ").append(this.getPath()).append(",");
        }
        if (this.getStartLine() != null) {
            sb.append("StartLine: ").append(this.getStartLine());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilePath)) {
            return false;
        }
        FilePath other = (FilePath)obj;
        if (other.getCodeSnippet() == null ^ this.getCodeSnippet() == null) {
            return false;
        }
        if (other.getCodeSnippet() != null && !other.getCodeSnippet().equals(this.getCodeSnippet())) {
            return false;
        }
        if (other.getEndLine() == null ^ this.getEndLine() == null) {
            return false;
        }
        if (other.getEndLine() != null && !other.getEndLine().equals(this.getEndLine())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getPath() == null ^ this.getPath() == null) {
            return false;
        }
        if (other.getPath() != null && !other.getPath().equals(this.getPath())) {
            return false;
        }
        if (other.getStartLine() == null ^ this.getStartLine() == null) {
            return false;
        }
        return other.getStartLine() == null || other.getStartLine().equals(this.getStartLine());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCodeSnippet() == null ? 0 : this.getCodeSnippet().hashCode());
        hashCode = 31 * hashCode + (this.getEndLine() == null ? 0 : this.getEndLine().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getPath() == null ? 0 : this.getPath().hashCode());
        hashCode = 31 * hashCode + (this.getStartLine() == null ? 0 : this.getStartLine().hashCode());
        return hashCode;
    }

    public FilePath clone() {
        try {
            return (FilePath)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FilePathMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

