/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codegurureviewer.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codegurureviewer.model.Repository;

@SdkInternalApi
public class RepositoryMarshaller {
    private static final MarshallingInfo<StructuredPojo> CODECOMMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CodeCommit").build();
    private static final MarshallingInfo<StructuredPojo> BITBUCKET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Bitbucket").build();
    private static final MarshallingInfo<StructuredPojo> GITHUBENTERPRISESERVER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GitHubEnterpriseServer").build();
    private static final MarshallingInfo<StructuredPojo> S3BUCKET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Bucket").build();
    private static final RepositoryMarshaller instance = new RepositoryMarshaller();

    public static RepositoryMarshaller getInstance() {
        return instance;
    }

    public void marshall(Repository repository, ProtocolMarshaller protocolMarshaller) {
        if (repository == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)repository.getCodeCommit(), CODECOMMIT_BINDING);
            protocolMarshaller.marshall((Object)repository.getBitbucket(), BITBUCKET_BINDING);
            protocolMarshaller.marshall((Object)repository.getGitHubEnterpriseServer(), GITHUBENTERPRISESERVER_BINDING);
            protocolMarshaller.marshall((Object)repository.getS3Bucket(), S3BUCKET_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

