/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class BatchGetDeploymentTargetsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String deploymentId;
    private SdkInternalList<String> targetIds;

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public BatchGetDeploymentTargetsRequest withDeploymentId(String deploymentId) {
        this.setDeploymentId(deploymentId);
        return this;
    }

    public List<String> getTargetIds() {
        if (this.targetIds == null) {
            this.targetIds = new SdkInternalList();
        }
        return this.targetIds;
    }

    public void setTargetIds(Collection<String> targetIds) {
        if (targetIds == null) {
            this.targetIds = null;
            return;
        }
        this.targetIds = new SdkInternalList(targetIds);
    }

    public BatchGetDeploymentTargetsRequest withTargetIds(String ... targetIds) {
        if (this.targetIds == null) {
            this.setTargetIds((Collection<String>)new SdkInternalList(targetIds.length));
        }
        for (String ele : targetIds) {
            this.targetIds.add((Object)ele);
        }
        return this;
    }

    public BatchGetDeploymentTargetsRequest withTargetIds(Collection<String> targetIds) {
        this.setTargetIds(targetIds);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDeploymentId() != null) {
            sb.append("DeploymentId: ").append(this.getDeploymentId()).append(",");
        }
        if (this.getTargetIds() != null) {
            sb.append("TargetIds: ").append(this.getTargetIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDeploymentTargetsRequest)) {
            return false;
        }
        BatchGetDeploymentTargetsRequest other = (BatchGetDeploymentTargetsRequest)obj;
        if (other.getDeploymentId() == null ^ this.getDeploymentId() == null) {
            return false;
        }
        if (other.getDeploymentId() != null && !other.getDeploymentId().equals(this.getDeploymentId())) {
            return false;
        }
        if (other.getTargetIds() == null ^ this.getTargetIds() == null) {
            return false;
        }
        return other.getTargetIds() == null || other.getTargetIds().equals(this.getTargetIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDeploymentId() == null ? 0 : this.getDeploymentId().hashCode());
        hashCode = 31 * hashCode + (this.getTargetIds() == null ? 0 : this.getTargetIds().hashCode());
        return hashCode;
    }

    public BatchGetDeploymentTargetsRequest clone() {
        return (BatchGetDeploymentTargetsRequest)super.clone();
    }
}

