/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codecommit.model.FileModeTypeEnum;
import com.amazonaws.services.codecommit.model.SourceFileSpecifier;
import com.amazonaws.services.codecommit.model.transform.PutFileEntryMarshaller;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class PutFileEntry
implements Serializable,
Cloneable,
StructuredPojo {
    private String filePath;
    private String fileMode;
    private ByteBuffer fileContent;
    private SourceFileSpecifier sourceFile;

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public PutFileEntry withFilePath(String filePath) {
        this.setFilePath(filePath);
        return this;
    }

    public void setFileMode(String fileMode) {
        this.fileMode = fileMode;
    }

    public String getFileMode() {
        return this.fileMode;
    }

    public PutFileEntry withFileMode(String fileMode) {
        this.setFileMode(fileMode);
        return this;
    }

    public PutFileEntry withFileMode(FileModeTypeEnum fileMode) {
        this.fileMode = fileMode.toString();
        return this;
    }

    public void setFileContent(ByteBuffer fileContent) {
        this.fileContent = fileContent;
    }

    public ByteBuffer getFileContent() {
        return this.fileContent;
    }

    public PutFileEntry withFileContent(ByteBuffer fileContent) {
        this.setFileContent(fileContent);
        return this;
    }

    public void setSourceFile(SourceFileSpecifier sourceFile) {
        this.sourceFile = sourceFile;
    }

    public SourceFileSpecifier getSourceFile() {
        return this.sourceFile;
    }

    public PutFileEntry withSourceFile(SourceFileSpecifier sourceFile) {
        this.setSourceFile(sourceFile);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFilePath() != null) {
            sb.append("FilePath: ").append(this.getFilePath()).append(",");
        }
        if (this.getFileMode() != null) {
            sb.append("FileMode: ").append(this.getFileMode()).append(",");
        }
        if (this.getFileContent() != null) {
            sb.append("FileContent: ").append(this.getFileContent()).append(",");
        }
        if (this.getSourceFile() != null) {
            sb.append("SourceFile: ").append(this.getSourceFile());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutFileEntry)) {
            return false;
        }
        PutFileEntry other = (PutFileEntry)obj;
        if (other.getFilePath() == null ^ this.getFilePath() == null) {
            return false;
        }
        if (other.getFilePath() != null && !other.getFilePath().equals(this.getFilePath())) {
            return false;
        }
        if (other.getFileMode() == null ^ this.getFileMode() == null) {
            return false;
        }
        if (other.getFileMode() != null && !other.getFileMode().equals(this.getFileMode())) {
            return false;
        }
        if (other.getFileContent() == null ^ this.getFileContent() == null) {
            return false;
        }
        if (other.getFileContent() != null && !other.getFileContent().equals(this.getFileContent())) {
            return false;
        }
        if (other.getSourceFile() == null ^ this.getSourceFile() == null) {
            return false;
        }
        return other.getSourceFile() == null || other.getSourceFile().equals(this.getSourceFile());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFilePath() == null ? 0 : this.getFilePath().hashCode());
        hashCode = 31 * hashCode + (this.getFileMode() == null ? 0 : this.getFileMode().hashCode());
        hashCode = 31 * hashCode + (this.getFileContent() == null ? 0 : this.getFileContent().hashCode());
        hashCode = 31 * hashCode + (this.getSourceFile() == null ? 0 : this.getSourceFile().hashCode());
        return hashCode;
    }

    public PutFileEntry clone() {
        try {
            return (PutFileEntry)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PutFileEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

