/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevidently.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cloudwatchevidently.model.FeatureEvaluationStrategy;
import com.amazonaws.services.cloudwatchevidently.model.VariationConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateFeatureRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<VariationConfig> addOrUpdateVariations;
    private String defaultVariation;
    private String description;
    private Map<String, String> entityOverrides;
    private String evaluationStrategy;
    private String feature;
    private String project;
    private List<String> removeVariations;

    public List<VariationConfig> getAddOrUpdateVariations() {
        return this.addOrUpdateVariations;
    }

    public void setAddOrUpdateVariations(Collection<VariationConfig> addOrUpdateVariations) {
        if (addOrUpdateVariations == null) {
            this.addOrUpdateVariations = null;
            return;
        }
        this.addOrUpdateVariations = new ArrayList<VariationConfig>(addOrUpdateVariations);
    }

    public UpdateFeatureRequest withAddOrUpdateVariations(VariationConfig ... addOrUpdateVariations) {
        if (this.addOrUpdateVariations == null) {
            this.setAddOrUpdateVariations(new ArrayList<VariationConfig>(addOrUpdateVariations.length));
        }
        for (VariationConfig ele : addOrUpdateVariations) {
            this.addOrUpdateVariations.add(ele);
        }
        return this;
    }

    public UpdateFeatureRequest withAddOrUpdateVariations(Collection<VariationConfig> addOrUpdateVariations) {
        this.setAddOrUpdateVariations(addOrUpdateVariations);
        return this;
    }

    public void setDefaultVariation(String defaultVariation) {
        this.defaultVariation = defaultVariation;
    }

    public String getDefaultVariation() {
        return this.defaultVariation;
    }

    public UpdateFeatureRequest withDefaultVariation(String defaultVariation) {
        this.setDefaultVariation(defaultVariation);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdateFeatureRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public Map<String, String> getEntityOverrides() {
        return this.entityOverrides;
    }

    public void setEntityOverrides(Map<String, String> entityOverrides) {
        this.entityOverrides = entityOverrides;
    }

    public UpdateFeatureRequest withEntityOverrides(Map<String, String> entityOverrides) {
        this.setEntityOverrides(entityOverrides);
        return this;
    }

    public UpdateFeatureRequest addEntityOverridesEntry(String key, String value) {
        if (null == this.entityOverrides) {
            this.entityOverrides = new HashMap<String, String>();
        }
        if (this.entityOverrides.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.entityOverrides.put(key, value);
        return this;
    }

    public UpdateFeatureRequest clearEntityOverridesEntries() {
        this.entityOverrides = null;
        return this;
    }

    public void setEvaluationStrategy(String evaluationStrategy) {
        this.evaluationStrategy = evaluationStrategy;
    }

    public String getEvaluationStrategy() {
        return this.evaluationStrategy;
    }

    public UpdateFeatureRequest withEvaluationStrategy(String evaluationStrategy) {
        this.setEvaluationStrategy(evaluationStrategy);
        return this;
    }

    public UpdateFeatureRequest withEvaluationStrategy(FeatureEvaluationStrategy evaluationStrategy) {
        this.evaluationStrategy = evaluationStrategy.toString();
        return this;
    }

    public void setFeature(String feature) {
        this.feature = feature;
    }

    public String getFeature() {
        return this.feature;
    }

    public UpdateFeatureRequest withFeature(String feature) {
        this.setFeature(feature);
        return this;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getProject() {
        return this.project;
    }

    public UpdateFeatureRequest withProject(String project) {
        this.setProject(project);
        return this;
    }

    public List<String> getRemoveVariations() {
        return this.removeVariations;
    }

    public void setRemoveVariations(Collection<String> removeVariations) {
        if (removeVariations == null) {
            this.removeVariations = null;
            return;
        }
        this.removeVariations = new ArrayList<String>(removeVariations);
    }

    public UpdateFeatureRequest withRemoveVariations(String ... removeVariations) {
        if (this.removeVariations == null) {
            this.setRemoveVariations(new ArrayList<String>(removeVariations.length));
        }
        for (String ele : removeVariations) {
            this.removeVariations.add(ele);
        }
        return this;
    }

    public UpdateFeatureRequest withRemoveVariations(Collection<String> removeVariations) {
        this.setRemoveVariations(removeVariations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAddOrUpdateVariations() != null) {
            sb.append("AddOrUpdateVariations: ").append(this.getAddOrUpdateVariations()).append(",");
        }
        if (this.getDefaultVariation() != null) {
            sb.append("DefaultVariation: ").append(this.getDefaultVariation()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getEntityOverrides() != null) {
            sb.append("EntityOverrides: ").append(this.getEntityOverrides()).append(",");
        }
        if (this.getEvaluationStrategy() != null) {
            sb.append("EvaluationStrategy: ").append(this.getEvaluationStrategy()).append(",");
        }
        if (this.getFeature() != null) {
            sb.append("Feature: ").append(this.getFeature()).append(",");
        }
        if (this.getProject() != null) {
            sb.append("Project: ").append(this.getProject()).append(",");
        }
        if (this.getRemoveVariations() != null) {
            sb.append("RemoveVariations: ").append(this.getRemoveVariations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFeatureRequest)) {
            return false;
        }
        UpdateFeatureRequest other = (UpdateFeatureRequest)obj;
        if (other.getAddOrUpdateVariations() == null ^ this.getAddOrUpdateVariations() == null) {
            return false;
        }
        if (other.getAddOrUpdateVariations() != null && !other.getAddOrUpdateVariations().equals(this.getAddOrUpdateVariations())) {
            return false;
        }
        if (other.getDefaultVariation() == null ^ this.getDefaultVariation() == null) {
            return false;
        }
        if (other.getDefaultVariation() != null && !other.getDefaultVariation().equals(this.getDefaultVariation())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getEntityOverrides() == null ^ this.getEntityOverrides() == null) {
            return false;
        }
        if (other.getEntityOverrides() != null && !other.getEntityOverrides().equals(this.getEntityOverrides())) {
            return false;
        }
        if (other.getEvaluationStrategy() == null ^ this.getEvaluationStrategy() == null) {
            return false;
        }
        if (other.getEvaluationStrategy() != null && !other.getEvaluationStrategy().equals(this.getEvaluationStrategy())) {
            return false;
        }
        if (other.getFeature() == null ^ this.getFeature() == null) {
            return false;
        }
        if (other.getFeature() != null && !other.getFeature().equals(this.getFeature())) {
            return false;
        }
        if (other.getProject() == null ^ this.getProject() == null) {
            return false;
        }
        if (other.getProject() != null && !other.getProject().equals(this.getProject())) {
            return false;
        }
        if (other.getRemoveVariations() == null ^ this.getRemoveVariations() == null) {
            return false;
        }
        return other.getRemoveVariations() == null || other.getRemoveVariations().equals(this.getRemoveVariations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAddOrUpdateVariations() == null ? 0 : this.getAddOrUpdateVariations().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultVariation() == null ? 0 : this.getDefaultVariation().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getEntityOverrides() == null ? 0 : this.getEntityOverrides().hashCode());
        hashCode = 31 * hashCode + (this.getEvaluationStrategy() == null ? 0 : this.getEvaluationStrategy().hashCode());
        hashCode = 31 * hashCode + (this.getFeature() == null ? 0 : this.getFeature().hashCode());
        hashCode = 31 * hashCode + (this.getProject() == null ? 0 : this.getProject().hashCode());
        hashCode = 31 * hashCode + (this.getRemoveVariations() == null ? 0 : this.getRemoveVariations().hashCode());
        return hashCode;
    }

    public UpdateFeatureRequest clone() {
        return (UpdateFeatureRequest)super.clone();
    }
}

