/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevidently.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cloudwatchevidently.model.FeatureEvaluationStrategy;
import com.amazonaws.services.cloudwatchevidently.model.VariationConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateFeatureRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String defaultVariation;
    private String description;
    private Map<String, String> entityOverrides;
    private String evaluationStrategy;
    private String name;
    private String project;
    private Map<String, String> tags;
    private List<VariationConfig> variations;

    public void setDefaultVariation(String defaultVariation) {
        this.defaultVariation = defaultVariation;
    }

    public String getDefaultVariation() {
        return this.defaultVariation;
    }

    public CreateFeatureRequest withDefaultVariation(String defaultVariation) {
        this.setDefaultVariation(defaultVariation);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateFeatureRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public Map<String, String> getEntityOverrides() {
        return this.entityOverrides;
    }

    public void setEntityOverrides(Map<String, String> entityOverrides) {
        this.entityOverrides = entityOverrides;
    }

    public CreateFeatureRequest withEntityOverrides(Map<String, String> entityOverrides) {
        this.setEntityOverrides(entityOverrides);
        return this;
    }

    public CreateFeatureRequest addEntityOverridesEntry(String key, String value) {
        if (null == this.entityOverrides) {
            this.entityOverrides = new HashMap<String, String>();
        }
        if (this.entityOverrides.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.entityOverrides.put(key, value);
        return this;
    }

    public CreateFeatureRequest clearEntityOverridesEntries() {
        this.entityOverrides = null;
        return this;
    }

    public void setEvaluationStrategy(String evaluationStrategy) {
        this.evaluationStrategy = evaluationStrategy;
    }

    public String getEvaluationStrategy() {
        return this.evaluationStrategy;
    }

    public CreateFeatureRequest withEvaluationStrategy(String evaluationStrategy) {
        this.setEvaluationStrategy(evaluationStrategy);
        return this;
    }

    public CreateFeatureRequest withEvaluationStrategy(FeatureEvaluationStrategy evaluationStrategy) {
        this.evaluationStrategy = evaluationStrategy.toString();
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateFeatureRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getProject() {
        return this.project;
    }

    public CreateFeatureRequest withProject(String project) {
        this.setProject(project);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateFeatureRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateFeatureRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateFeatureRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public List<VariationConfig> getVariations() {
        return this.variations;
    }

    public void setVariations(Collection<VariationConfig> variations) {
        if (variations == null) {
            this.variations = null;
            return;
        }
        this.variations = new ArrayList<VariationConfig>(variations);
    }

    public CreateFeatureRequest withVariations(VariationConfig ... variations) {
        if (this.variations == null) {
            this.setVariations(new ArrayList<VariationConfig>(variations.length));
        }
        for (VariationConfig ele : variations) {
            this.variations.add(ele);
        }
        return this;
    }

    public CreateFeatureRequest withVariations(Collection<VariationConfig> variations) {
        this.setVariations(variations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDefaultVariation() != null) {
            sb.append("DefaultVariation: ").append(this.getDefaultVariation()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getEntityOverrides() != null) {
            sb.append("EntityOverrides: ").append(this.getEntityOverrides()).append(",");
        }
        if (this.getEvaluationStrategy() != null) {
            sb.append("EvaluationStrategy: ").append(this.getEvaluationStrategy()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getProject() != null) {
            sb.append("Project: ").append(this.getProject()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getVariations() != null) {
            sb.append("Variations: ").append(this.getVariations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFeatureRequest)) {
            return false;
        }
        CreateFeatureRequest other = (CreateFeatureRequest)obj;
        if (other.getDefaultVariation() == null ^ this.getDefaultVariation() == null) {
            return false;
        }
        if (other.getDefaultVariation() != null && !other.getDefaultVariation().equals(this.getDefaultVariation())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getEntityOverrides() == null ^ this.getEntityOverrides() == null) {
            return false;
        }
        if (other.getEntityOverrides() != null && !other.getEntityOverrides().equals(this.getEntityOverrides())) {
            return false;
        }
        if (other.getEvaluationStrategy() == null ^ this.getEvaluationStrategy() == null) {
            return false;
        }
        if (other.getEvaluationStrategy() != null && !other.getEvaluationStrategy().equals(this.getEvaluationStrategy())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getProject() == null ^ this.getProject() == null) {
            return false;
        }
        if (other.getProject() != null && !other.getProject().equals(this.getProject())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getVariations() == null ^ this.getVariations() == null) {
            return false;
        }
        return other.getVariations() == null || other.getVariations().equals(this.getVariations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDefaultVariation() == null ? 0 : this.getDefaultVariation().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getEntityOverrides() == null ? 0 : this.getEntityOverrides().hashCode());
        hashCode = 31 * hashCode + (this.getEvaluationStrategy() == null ? 0 : this.getEvaluationStrategy().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getProject() == null ? 0 : this.getProject().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getVariations() == null ? 0 : this.getVariations().hashCode());
        return hashCode;
    }

    public CreateFeatureRequest clone() {
        return (CreateFeatureRequest)super.clone();
    }
}

