/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudwatch.model.PutInsightRuleRequest;
import com.amazonaws.services.cloudwatch.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class PutInsightRuleRequestMarshaller
implements Marshaller<Request<PutInsightRuleRequest>, PutInsightRuleRequest> {
    public Request<PutInsightRuleRequest> marshall(PutInsightRuleRequest putInsightRuleRequest) {
        if (putInsightRuleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putInsightRuleRequest, "AmazonCloudWatch");
        request.addParameter("Action", "PutInsightRule");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putInsightRuleRequest.getRuleName() != null) {
            request.addParameter("RuleName", StringUtils.fromString((String)putInsightRuleRequest.getRuleName()));
        }
        if (putInsightRuleRequest.getRuleState() != null) {
            request.addParameter("RuleState", StringUtils.fromString((String)putInsightRuleRequest.getRuleState()));
        }
        if (putInsightRuleRequest.getRuleDefinition() != null) {
            request.addParameter("RuleDefinition", StringUtils.fromString((String)putInsightRuleRequest.getRuleDefinition()));
        }
        if (!putInsightRuleRequest.getTags().isEmpty() || !((SdkInternalList)putInsightRuleRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)putInsightRuleRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

