/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.services.cloudwatch.model.ManagedRule;
import com.amazonaws.services.cloudwatch.model.Tag;
import com.amazonaws.services.cloudwatch.model.transform.TagStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class ManagedRuleStaxUnmarshaller
implements Unmarshaller<ManagedRule, StaxUnmarshallerContext> {
    private static ManagedRuleStaxUnmarshaller instance;

    public ManagedRule unmarshall(StaxUnmarshallerContext context) throws Exception {
        ManagedRule managedRule = new ManagedRule();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return managedRule;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("TemplateName", targetDepth)) {
                    managedRule.setTemplateName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ResourceARN", targetDepth)) {
                    managedRule.setResourceARN(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Tags", targetDepth)) {
                    managedRule.withTags(new ArrayList<Tag>());
                    continue;
                }
                if (!context.testExpression("Tags/member", targetDepth)) continue;
                managedRule.withTags(TagStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return managedRule;
    }

    public static ManagedRuleStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ManagedRuleStaxUnmarshaller();
        }
        return instance;
    }
}

