/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.cloudtrail.model.EventDataStore;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class EventDataStoreMarshaller {
    private static final MarshallingInfo<String> EVENTDATASTOREARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventDataStoreArn").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<Boolean> TERMINATIONPROTECTIONENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TerminationProtectionEnabled").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<List> ADVANCEDEVENTSELECTORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdvancedEventSelectors").build();
    private static final MarshallingInfo<Boolean> MULTIREGIONENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MultiRegionEnabled").build();
    private static final MarshallingInfo<Boolean> ORGANIZATIONENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OrganizationEnabled").build();
    private static final MarshallingInfo<Integer> RETENTIONPERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RetentionPeriod").build();
    private static final MarshallingInfo<Date> CREATEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTimestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> UPDATEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpdatedTimestamp").timestampFormat("unixTimestamp").build();
    private static final EventDataStoreMarshaller instance = new EventDataStoreMarshaller();

    public static EventDataStoreMarshaller getInstance() {
        return instance;
    }

    public void marshall(EventDataStore eventDataStore, ProtocolMarshaller protocolMarshaller) {
        if (eventDataStore == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)eventDataStore.getEventDataStoreArn(), EVENTDATASTOREARN_BINDING);
            protocolMarshaller.marshall((Object)eventDataStore.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)eventDataStore.getTerminationProtectionEnabled(), TERMINATIONPROTECTIONENABLED_BINDING);
            protocolMarshaller.marshall((Object)eventDataStore.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(eventDataStore.getAdvancedEventSelectors(), ADVANCEDEVENTSELECTORS_BINDING);
            protocolMarshaller.marshall((Object)eventDataStore.getMultiRegionEnabled(), MULTIREGIONENABLED_BINDING);
            protocolMarshaller.marshall((Object)eventDataStore.getOrganizationEnabled(), ORGANIZATIONENABLED_BINDING);
            protocolMarshaller.marshall((Object)eventDataStore.getRetentionPeriod(), RETENTIONPERIOD_BINDING);
            protocolMarshaller.marshall((Object)eventDataStore.getCreatedTimestamp(), CREATEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)eventDataStore.getUpdatedTimestamp(), UPDATEDTIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

