/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.UpdateKeyValueStoreRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class UpdateKeyValueStoreRequestMarshaller
implements Marshaller<Request<UpdateKeyValueStoreRequest>, UpdateKeyValueStoreRequest> {
    public Request<UpdateKeyValueStoreRequest> marshall(UpdateKeyValueStoreRequest updateKeyValueStoreRequest) {
        if (updateKeyValueStoreRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateKeyValueStoreRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.PUT);
        if (updateKeyValueStoreRequest.getIfMatch() != null) {
            request.addHeader("If-Match", StringUtils.fromString((String)updateKeyValueStoreRequest.getIfMatch()));
        }
        String uriResourcePath = "/2020-05-31/key-value-store/{Name}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Name", updateKeyValueStoreRequest.getName());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://cloudfront.amazonaws.com/doc/2020-05-31/");
            xmlWriter.startElement("UpdateKeyValueStoreRequest");
            if (updateKeyValueStoreRequest != null && updateKeyValueStoreRequest.getComment() != null) {
                xmlWriter.startElement("Comment").value(updateKeyValueStoreRequest.getComment()).endElement();
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

