/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.OriginAccessControlConfig;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class OriginAccessControlConfigStaxUnmarshaller
implements Unmarshaller<OriginAccessControlConfig, StaxUnmarshallerContext> {
    private static OriginAccessControlConfigStaxUnmarshaller instance;

    public OriginAccessControlConfig unmarshall(StaxUnmarshallerContext context) throws Exception {
        OriginAccessControlConfig originAccessControlConfig = new OriginAccessControlConfig();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return originAccessControlConfig;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Name", targetDepth)) {
                    originAccessControlConfig.setName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Description", targetDepth)) {
                    originAccessControlConfig.setDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SigningProtocol", targetDepth)) {
                    originAccessControlConfig.setSigningProtocol(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SigningBehavior", targetDepth)) {
                    originAccessControlConfig.setSigningBehavior(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("OriginAccessControlOriginType", targetDepth)) continue;
                originAccessControlConfig.setOriginAccessControlOriginType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return originAccessControlConfig;
    }

    public static OriginAccessControlConfigStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new OriginAccessControlConfigStaxUnmarshaller();
        }
        return instance;
    }
}

