/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.CreateKeyValueStoreRequest;
import com.amazonaws.services.cloudfront.model.ImportSource;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreateKeyValueStoreRequestMarshaller
implements Marshaller<Request<CreateKeyValueStoreRequest>, CreateKeyValueStoreRequest> {
    public Request<CreateKeyValueStoreRequest> marshall(CreateKeyValueStoreRequest createKeyValueStoreRequest) {
        if (createKeyValueStoreRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createKeyValueStoreRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2020-05-31/key-value-store/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://cloudfront.amazonaws.com/doc/2020-05-31/");
            xmlWriter.startElement("CreateKeyValueStoreRequest");
            if (createKeyValueStoreRequest != null) {
                ImportSource importSource;
                if (createKeyValueStoreRequest.getName() != null) {
                    xmlWriter.startElement("Name").value(createKeyValueStoreRequest.getName()).endElement();
                }
                if (createKeyValueStoreRequest.getComment() != null) {
                    xmlWriter.startElement("Comment").value(createKeyValueStoreRequest.getComment()).endElement();
                }
                if ((importSource = createKeyValueStoreRequest.getImportSource()) != null) {
                    xmlWriter.startElement("ImportSource");
                    if (importSource.getSourceType() != null) {
                        xmlWriter.startElement("SourceType").value(importSource.getSourceType()).endElement();
                    }
                    if (importSource.getSourceARN() != null) {
                        xmlWriter.startElement("SourceARN").value(importSource.getSourceARN()).endElement();
                    }
                    xmlWriter.endElement();
                }
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

