/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.ContentTypeProfile;
import com.amazonaws.services.cloudfront.model.ContentTypeProfiles;
import com.amazonaws.services.cloudfront.model.transform.ContentTypeProfileStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class ContentTypeProfilesStaxUnmarshaller
implements Unmarshaller<ContentTypeProfiles, StaxUnmarshallerContext> {
    private static ContentTypeProfilesStaxUnmarshaller instance;

    public ContentTypeProfiles unmarshall(StaxUnmarshallerContext context) throws Exception {
        ContentTypeProfiles contentTypeProfiles = new ContentTypeProfiles();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return contentTypeProfiles;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Quantity", targetDepth)) {
                    contentTypeProfiles.setQuantity(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Items", targetDepth)) {
                    contentTypeProfiles.withItems(new ArrayList<ContentTypeProfile>());
                    continue;
                }
                if (!context.testExpression("Items/ContentTypeProfile", targetDepth)) continue;
                contentTypeProfiles.withItems(ContentTypeProfileStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return contentTypeProfiles;
    }

    public static ContentTypeProfilesStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ContentTypeProfilesStaxUnmarshaller();
        }
        return instance;
    }
}

