/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.ImportStacksToStackSetRequest;
import com.amazonaws.services.cloudformation.model.StackSetOperationPreferences;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class ImportStacksToStackSetRequestMarshaller
implements Marshaller<Request<ImportStacksToStackSetRequest>, ImportStacksToStackSetRequest> {
    public Request<ImportStacksToStackSetRequest> marshall(ImportStacksToStackSetRequest importStacksToStackSetRequest) {
        StackSetOperationPreferences operationPreferences;
        if (importStacksToStackSetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)importStacksToStackSetRequest, "AmazonCloudFormation");
        request.addParameter("Action", "ImportStacksToStackSet");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (importStacksToStackSetRequest.getStackSetName() != null) {
            request.addParameter("StackSetName", StringUtils.fromString((String)importStacksToStackSetRequest.getStackSetName()));
        }
        if (importStacksToStackSetRequest.getStackIds().isEmpty() && !((SdkInternalList)importStacksToStackSetRequest.getStackIds()).isAutoConstruct()) {
            request.addParameter("StackIds", "");
        }
        if (!importStacksToStackSetRequest.getStackIds().isEmpty() || !((SdkInternalList)importStacksToStackSetRequest.getStackIds()).isAutoConstruct()) {
            SdkInternalList stackIdsList = (SdkInternalList)importStacksToStackSetRequest.getStackIds();
            int stackIdsListIndex = 1;
            for (String stackIdsListValue : stackIdsList) {
                if (stackIdsListValue != null) {
                    request.addParameter("StackIds.member." + stackIdsListIndex, StringUtils.fromString((String)stackIdsListValue));
                }
                ++stackIdsListIndex;
            }
        }
        if (importStacksToStackSetRequest.getStackIdsUrl() != null) {
            request.addParameter("StackIdsUrl", StringUtils.fromString((String)importStacksToStackSetRequest.getStackIdsUrl()));
        }
        if (importStacksToStackSetRequest.getOrganizationalUnitIds().isEmpty() && !((SdkInternalList)importStacksToStackSetRequest.getOrganizationalUnitIds()).isAutoConstruct()) {
            request.addParameter("OrganizationalUnitIds", "");
        }
        if (!importStacksToStackSetRequest.getOrganizationalUnitIds().isEmpty() || !((SdkInternalList)importStacksToStackSetRequest.getOrganizationalUnitIds()).isAutoConstruct()) {
            SdkInternalList organizationalUnitIdsList = (SdkInternalList)importStacksToStackSetRequest.getOrganizationalUnitIds();
            int organizationalUnitIdsListIndex = 1;
            for (String organizationalUnitIdsListValue : organizationalUnitIdsList) {
                if (organizationalUnitIdsListValue != null) {
                    request.addParameter("OrganizationalUnitIds.member." + organizationalUnitIdsListIndex, StringUtils.fromString((String)organizationalUnitIdsListValue));
                }
                ++organizationalUnitIdsListIndex;
            }
        }
        if ((operationPreferences = importStacksToStackSetRequest.getOperationPreferences()) != null) {
            if (operationPreferences.getRegionConcurrencyType() != null) {
                request.addParameter("OperationPreferences.RegionConcurrencyType", StringUtils.fromString((String)operationPreferences.getRegionConcurrencyType()));
            }
            if (operationPreferences.getRegionOrder().isEmpty() && !((SdkInternalList)operationPreferences.getRegionOrder()).isAutoConstruct()) {
                request.addParameter("OperationPreferences.RegionOrder", "");
            }
            if (!operationPreferences.getRegionOrder().isEmpty() || !((SdkInternalList)operationPreferences.getRegionOrder()).isAutoConstruct()) {
                SdkInternalList regionOrderList = (SdkInternalList)operationPreferences.getRegionOrder();
                int regionOrderListIndex = 1;
                for (String regionOrderListValue : regionOrderList) {
                    if (regionOrderListValue != null) {
                        request.addParameter("OperationPreferences.RegionOrder.member." + regionOrderListIndex, StringUtils.fromString((String)regionOrderListValue));
                    }
                    ++regionOrderListIndex;
                }
            }
            if (operationPreferences.getFailureToleranceCount() != null) {
                request.addParameter("OperationPreferences.FailureToleranceCount", StringUtils.fromInteger((Integer)operationPreferences.getFailureToleranceCount()));
            }
            if (operationPreferences.getFailureTolerancePercentage() != null) {
                request.addParameter("OperationPreferences.FailureTolerancePercentage", StringUtils.fromInteger((Integer)operationPreferences.getFailureTolerancePercentage()));
            }
            if (operationPreferences.getMaxConcurrentCount() != null) {
                request.addParameter("OperationPreferences.MaxConcurrentCount", StringUtils.fromInteger((Integer)operationPreferences.getMaxConcurrentCount()));
            }
            if (operationPreferences.getMaxConcurrentPercentage() != null) {
                request.addParameter("OperationPreferences.MaxConcurrentPercentage", StringUtils.fromInteger((Integer)operationPreferences.getMaxConcurrentPercentage()));
            }
            if (operationPreferences.getConcurrencyMode() != null) {
                request.addParameter("OperationPreferences.ConcurrencyMode", StringUtils.fromString((String)operationPreferences.getConcurrencyMode()));
            }
        }
        request.addParameter("OperationId", IdempotentUtils.resolveString((String)importStacksToStackSetRequest.getOperationId()));
        if (importStacksToStackSetRequest.getCallAs() != null) {
            request.addParameter("CallAs", StringUtils.fromString((String)importStacksToStackSetRequest.getCallAs()));
        }
        return request;
    }
}

