/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.DetectStackSetDriftRequest;
import com.amazonaws.services.cloudformation.model.StackSetOperationPreferences;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class DetectStackSetDriftRequestMarshaller
implements Marshaller<Request<DetectStackSetDriftRequest>, DetectStackSetDriftRequest> {
    public Request<DetectStackSetDriftRequest> marshall(DetectStackSetDriftRequest detectStackSetDriftRequest) {
        StackSetOperationPreferences operationPreferences;
        if (detectStackSetDriftRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)detectStackSetDriftRequest, "AmazonCloudFormation");
        request.addParameter("Action", "DetectStackSetDrift");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (detectStackSetDriftRequest.getStackSetName() != null) {
            request.addParameter("StackSetName", StringUtils.fromString((String)detectStackSetDriftRequest.getStackSetName()));
        }
        if ((operationPreferences = detectStackSetDriftRequest.getOperationPreferences()) != null) {
            if (operationPreferences.getRegionConcurrencyType() != null) {
                request.addParameter("OperationPreferences.RegionConcurrencyType", StringUtils.fromString((String)operationPreferences.getRegionConcurrencyType()));
            }
            if (operationPreferences.getRegionOrder().isEmpty() && !((SdkInternalList)operationPreferences.getRegionOrder()).isAutoConstruct()) {
                request.addParameter("OperationPreferences.RegionOrder", "");
            }
            if (!operationPreferences.getRegionOrder().isEmpty() || !((SdkInternalList)operationPreferences.getRegionOrder()).isAutoConstruct()) {
                SdkInternalList regionOrderList = (SdkInternalList)operationPreferences.getRegionOrder();
                int regionOrderListIndex = 1;
                for (String regionOrderListValue : regionOrderList) {
                    if (regionOrderListValue != null) {
                        request.addParameter("OperationPreferences.RegionOrder.member." + regionOrderListIndex, StringUtils.fromString((String)regionOrderListValue));
                    }
                    ++regionOrderListIndex;
                }
            }
            if (operationPreferences.getFailureToleranceCount() != null) {
                request.addParameter("OperationPreferences.FailureToleranceCount", StringUtils.fromInteger((Integer)operationPreferences.getFailureToleranceCount()));
            }
            if (operationPreferences.getFailureTolerancePercentage() != null) {
                request.addParameter("OperationPreferences.FailureTolerancePercentage", StringUtils.fromInteger((Integer)operationPreferences.getFailureTolerancePercentage()));
            }
            if (operationPreferences.getMaxConcurrentCount() != null) {
                request.addParameter("OperationPreferences.MaxConcurrentCount", StringUtils.fromInteger((Integer)operationPreferences.getMaxConcurrentCount()));
            }
            if (operationPreferences.getMaxConcurrentPercentage() != null) {
                request.addParameter("OperationPreferences.MaxConcurrentPercentage", StringUtils.fromInteger((Integer)operationPreferences.getMaxConcurrentPercentage()));
            }
            if (operationPreferences.getConcurrencyMode() != null) {
                request.addParameter("OperationPreferences.ConcurrencyMode", StringUtils.fromString((String)operationPreferences.getConcurrencyMode()));
            }
        }
        request.addParameter("OperationId", IdempotentUtils.resolveString((String)detectStackSetDriftRequest.getOperationId()));
        if (detectStackSetDriftRequest.getCallAs() != null) {
            request.addParameter("CallAs", StringUtils.fromString((String)detectStackSetDriftRequest.getCallAs()));
        }
        return request;
    }
}

