/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.clouddirectory.model.AttributeKeyAndValue;
import com.amazonaws.services.clouddirectory.model.ObjectReference;
import com.amazonaws.services.clouddirectory.model.SchemaFacet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AddFacetToObjectRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String directoryArn;
    private SchemaFacet schemaFacet;
    private List<AttributeKeyAndValue> objectAttributeList;
    private ObjectReference objectReference;

    public void setDirectoryArn(String directoryArn) {
        this.directoryArn = directoryArn;
    }

    public String getDirectoryArn() {
        return this.directoryArn;
    }

    public AddFacetToObjectRequest withDirectoryArn(String directoryArn) {
        this.setDirectoryArn(directoryArn);
        return this;
    }

    public void setSchemaFacet(SchemaFacet schemaFacet) {
        this.schemaFacet = schemaFacet;
    }

    public SchemaFacet getSchemaFacet() {
        return this.schemaFacet;
    }

    public AddFacetToObjectRequest withSchemaFacet(SchemaFacet schemaFacet) {
        this.setSchemaFacet(schemaFacet);
        return this;
    }

    public List<AttributeKeyAndValue> getObjectAttributeList() {
        return this.objectAttributeList;
    }

    public void setObjectAttributeList(Collection<AttributeKeyAndValue> objectAttributeList) {
        if (objectAttributeList == null) {
            this.objectAttributeList = null;
            return;
        }
        this.objectAttributeList = new ArrayList<AttributeKeyAndValue>(objectAttributeList);
    }

    public AddFacetToObjectRequest withObjectAttributeList(AttributeKeyAndValue ... objectAttributeList) {
        if (this.objectAttributeList == null) {
            this.setObjectAttributeList(new ArrayList<AttributeKeyAndValue>(objectAttributeList.length));
        }
        for (AttributeKeyAndValue ele : objectAttributeList) {
            this.objectAttributeList.add(ele);
        }
        return this;
    }

    public AddFacetToObjectRequest withObjectAttributeList(Collection<AttributeKeyAndValue> objectAttributeList) {
        this.setObjectAttributeList(objectAttributeList);
        return this;
    }

    public void setObjectReference(ObjectReference objectReference) {
        this.objectReference = objectReference;
    }

    public ObjectReference getObjectReference() {
        return this.objectReference;
    }

    public AddFacetToObjectRequest withObjectReference(ObjectReference objectReference) {
        this.setObjectReference(objectReference);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDirectoryArn() != null) {
            sb.append("DirectoryArn: ").append(this.getDirectoryArn()).append(",");
        }
        if (this.getSchemaFacet() != null) {
            sb.append("SchemaFacet: ").append(this.getSchemaFacet()).append(",");
        }
        if (this.getObjectAttributeList() != null) {
            sb.append("ObjectAttributeList: ").append(this.getObjectAttributeList()).append(",");
        }
        if (this.getObjectReference() != null) {
            sb.append("ObjectReference: ").append(this.getObjectReference());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddFacetToObjectRequest)) {
            return false;
        }
        AddFacetToObjectRequest other = (AddFacetToObjectRequest)obj;
        if (other.getDirectoryArn() == null ^ this.getDirectoryArn() == null) {
            return false;
        }
        if (other.getDirectoryArn() != null && !other.getDirectoryArn().equals(this.getDirectoryArn())) {
            return false;
        }
        if (other.getSchemaFacet() == null ^ this.getSchemaFacet() == null) {
            return false;
        }
        if (other.getSchemaFacet() != null && !other.getSchemaFacet().equals(this.getSchemaFacet())) {
            return false;
        }
        if (other.getObjectAttributeList() == null ^ this.getObjectAttributeList() == null) {
            return false;
        }
        if (other.getObjectAttributeList() != null && !other.getObjectAttributeList().equals(this.getObjectAttributeList())) {
            return false;
        }
        if (other.getObjectReference() == null ^ this.getObjectReference() == null) {
            return false;
        }
        return other.getObjectReference() == null || other.getObjectReference().equals(this.getObjectReference());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDirectoryArn() == null ? 0 : this.getDirectoryArn().hashCode());
        hashCode = 31 * hashCode + (this.getSchemaFacet() == null ? 0 : this.getSchemaFacet().hashCode());
        hashCode = 31 * hashCode + (this.getObjectAttributeList() == null ? 0 : this.getObjectAttributeList().hashCode());
        hashCode = 31 * hashCode + (this.getObjectReference() == null ? 0 : this.getObjectReference().hashCode());
        return hashCode;
    }

    public AddFacetToObjectRequest clone() {
        return (AddFacetToObjectRequest)super.clone();
    }
}

