/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudcontrolapi;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.cloudcontrolapi.AWSCloudControlApi;
import com.amazonaws.services.cloudcontrolapi.AWSCloudControlApiClientBuilder;
import com.amazonaws.services.cloudcontrolapi.model.AWSCloudControlApiException;
import com.amazonaws.services.cloudcontrolapi.model.CancelResourceRequestRequest;
import com.amazonaws.services.cloudcontrolapi.model.CancelResourceRequestResult;
import com.amazonaws.services.cloudcontrolapi.model.CreateResourceRequest;
import com.amazonaws.services.cloudcontrolapi.model.CreateResourceResult;
import com.amazonaws.services.cloudcontrolapi.model.DeleteResourceRequest;
import com.amazonaws.services.cloudcontrolapi.model.DeleteResourceResult;
import com.amazonaws.services.cloudcontrolapi.model.GetResourceRequest;
import com.amazonaws.services.cloudcontrolapi.model.GetResourceRequestStatusRequest;
import com.amazonaws.services.cloudcontrolapi.model.GetResourceRequestStatusResult;
import com.amazonaws.services.cloudcontrolapi.model.GetResourceResult;
import com.amazonaws.services.cloudcontrolapi.model.ListResourceRequestsRequest;
import com.amazonaws.services.cloudcontrolapi.model.ListResourceRequestsResult;
import com.amazonaws.services.cloudcontrolapi.model.ListResourcesRequest;
import com.amazonaws.services.cloudcontrolapi.model.ListResourcesResult;
import com.amazonaws.services.cloudcontrolapi.model.UpdateResourceRequest;
import com.amazonaws.services.cloudcontrolapi.model.UpdateResourceResult;
import com.amazonaws.services.cloudcontrolapi.model.transform.AlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.CancelResourceRequestRequestProtocolMarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.CancelResourceRequestResultJsonUnmarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.ClientTokenConflictExceptionUnmarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.ConcurrentModificationExceptionUnmarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.ConcurrentOperationExceptionUnmarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.CreateResourceRequestProtocolMarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.CreateResourceResultJsonUnmarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.DeleteResourceRequestProtocolMarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.DeleteResourceResultJsonUnmarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.GeneralServiceExceptionUnmarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.GetResourceRequestProtocolMarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.GetResourceRequestStatusRequestProtocolMarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.GetResourceRequestStatusResultJsonUnmarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.GetResourceResultJsonUnmarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.HandlerFailureExceptionUnmarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.HandlerInternalFailureExceptionUnmarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.InvalidCredentialsExceptionUnmarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.InvalidRequestExceptionUnmarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.ListResourceRequestsRequestProtocolMarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.ListResourceRequestsResultJsonUnmarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.ListResourcesRequestProtocolMarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.ListResourcesResultJsonUnmarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.NetworkFailureExceptionUnmarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.NotStabilizedExceptionUnmarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.NotUpdatableExceptionUnmarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.PrivateTypeExceptionUnmarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.RequestTokenNotFoundExceptionUnmarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.ResourceConflictExceptionUnmarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.ServiceInternalErrorExceptionUnmarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.ServiceLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.TypeNotFoundExceptionUnmarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.UnsupportedActionExceptionUnmarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.UpdateResourceRequestProtocolMarshaller;
import com.amazonaws.services.cloudcontrolapi.model.transform.UpdateResourceResultJsonUnmarshaller;
import com.amazonaws.services.cloudcontrolapi.waiters.AWSCloudControlApiWaiters;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSCloudControlApiClient
extends AmazonWebServiceClient
implements AWSCloudControlApi {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSCloudControlApi.class);
    private static final String DEFAULT_SIGNING_NAME = "cloudcontrolapi";
    private volatile AWSCloudControlApiWaiters waiters;
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.0").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConcurrentModificationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConcurrentModificationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("HandlerFailureException").withExceptionUnmarshaller((JsonErrorUnmarshaller)HandlerFailureExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("HandlerInternalFailureException").withExceptionUnmarshaller((JsonErrorUnmarshaller)HandlerInternalFailureExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceLimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceLimitExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceInternalErrorException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceInternalErrorExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PrivateTypeException").withExceptionUnmarshaller((JsonErrorUnmarshaller)PrivateTypeExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RequestTokenNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)RequestTokenNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ClientTokenConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ClientTokenConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRequestException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidRequestExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NetworkFailureException").withExceptionUnmarshaller((JsonErrorUnmarshaller)NetworkFailureExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AlreadyExistsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AlreadyExistsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConcurrentOperationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConcurrentOperationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedActionException").withExceptionUnmarshaller((JsonErrorUnmarshaller)UnsupportedActionExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotStabilizedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)NotStabilizedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidCredentialsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidCredentialsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("GeneralServiceException").withExceptionUnmarshaller((JsonErrorUnmarshaller)GeneralServiceExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TypeNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)TypeNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotUpdatableException").withExceptionUnmarshaller((JsonErrorUnmarshaller)NotUpdatableExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSCloudControlApiException.class));

    public static AWSCloudControlApiClientBuilder builder() {
        return AWSCloudControlApiClientBuilder.standard();
    }

    AWSCloudControlApiClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSCloudControlApiClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("cloudcontrolapi.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/cloudcontrolapi/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/cloudcontrolapi/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CancelResourceRequestResult cancelResourceRequest(CancelResourceRequestRequest request) {
        request = (CancelResourceRequestRequest)this.beforeClientExecution(request);
        return this.executeCancelResourceRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CancelResourceRequestResult executeCancelResourceRequest(CancelResourceRequestRequest cancelResourceRequestRequest) {
        ExecutionContext executionContext = this.createExecutionContext(cancelResourceRequestRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CancelResourceRequestRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CancelResourceRequestRequestProtocolMarshaller(protocolFactory).marshall((CancelResourceRequestRequest)super.beforeMarshalling((AmazonWebServiceRequest)cancelResourceRequestRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudControl");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CancelResourceRequest");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CancelResourceRequestResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CancelResourceRequestResult cancelResourceRequestResult = (CancelResourceRequestResult)response.getAwsResponse();
            return cancelResourceRequestResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateResourceResult createResource(CreateResourceRequest request) {
        request = (CreateResourceRequest)this.beforeClientExecution(request);
        return this.executeCreateResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateResourceResult executeCreateResource(CreateResourceRequest createResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateResourceRequestProtocolMarshaller(protocolFactory).marshall((CreateResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)createResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudControl");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateResourceResult createResourceResult = (CreateResourceResult)response.getAwsResponse();
            return createResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteResourceResult deleteResource(DeleteResourceRequest request) {
        request = (DeleteResourceRequest)this.beforeClientExecution(request);
        return this.executeDeleteResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteResourceResult executeDeleteResource(DeleteResourceRequest deleteResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteResourceRequestProtocolMarshaller(protocolFactory).marshall((DeleteResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudControl");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteResourceResult deleteResourceResult = (DeleteResourceResult)response.getAwsResponse();
            return deleteResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetResourceResult getResource(GetResourceRequest request) {
        request = (GetResourceRequest)this.beforeClientExecution(request);
        return this.executeGetResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetResourceResult executeGetResource(GetResourceRequest getResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetResourceRequestProtocolMarshaller(protocolFactory).marshall((GetResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)getResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudControl");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetResourceResult getResourceResult = (GetResourceResult)response.getAwsResponse();
            return getResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetResourceRequestStatusResult getResourceRequestStatus(GetResourceRequestStatusRequest request) {
        request = (GetResourceRequestStatusRequest)this.beforeClientExecution(request);
        return this.executeGetResourceRequestStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetResourceRequestStatusResult executeGetResourceRequestStatus(GetResourceRequestStatusRequest getResourceRequestStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getResourceRequestStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetResourceRequestStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetResourceRequestStatusRequestProtocolMarshaller(protocolFactory).marshall((GetResourceRequestStatusRequest)super.beforeMarshalling((AmazonWebServiceRequest)getResourceRequestStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudControl");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetResourceRequestStatus");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetResourceRequestStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetResourceRequestStatusResult getResourceRequestStatusResult = (GetResourceRequestStatusResult)response.getAwsResponse();
            return getResourceRequestStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListResourceRequestsResult listResourceRequests(ListResourceRequestsRequest request) {
        request = (ListResourceRequestsRequest)this.beforeClientExecution(request);
        return this.executeListResourceRequests(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListResourceRequestsResult executeListResourceRequests(ListResourceRequestsRequest listResourceRequestsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listResourceRequestsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListResourceRequestsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListResourceRequestsRequestProtocolMarshaller(protocolFactory).marshall((ListResourceRequestsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listResourceRequestsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudControl");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListResourceRequests");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListResourceRequestsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListResourceRequestsResult listResourceRequestsResult = (ListResourceRequestsResult)response.getAwsResponse();
            return listResourceRequestsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListResourcesResult listResources(ListResourcesRequest request) {
        request = (ListResourcesRequest)this.beforeClientExecution(request);
        return this.executeListResources(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListResourcesResult executeListResources(ListResourcesRequest listResourcesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listResourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListResourcesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListResourcesRequestProtocolMarshaller(protocolFactory).marshall((ListResourcesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listResourcesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudControl");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListResources");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListResourcesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListResourcesResult listResourcesResult = (ListResourcesResult)response.getAwsResponse();
            return listResourcesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateResourceResult updateResource(UpdateResourceRequest request) {
        request = (UpdateResourceRequest)this.beforeClientExecution(request);
        return this.executeUpdateResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateResourceResult executeUpdateResource(UpdateResourceRequest updateResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateResourceRequestProtocolMarshaller(protocolFactory).marshall((UpdateResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudControl");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateResourceResult updateResourceResult = (UpdateResourceResult)response.getAwsResponse();
            return updateResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AWSCloudControlApiWaiters waiters() {
        if (this.waiters == null) {
            AWSCloudControlApiClient aWSCloudControlApiClient = this;
            synchronized (aWSCloudControlApiClient) {
                if (this.waiters == null) {
                    this.waiters = new AWSCloudControlApiWaiters(this);
                }
            }
        }
        return this.waiters;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.waiters != null) {
            this.waiters.shutdown();
        }
    }
}

