/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cleanrooms.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.cleanrooms.model.CollaborationSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListCollaborationsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<CollaborationSummary> collaborationList;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListCollaborationsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<CollaborationSummary> getCollaborationList() {
        return this.collaborationList;
    }

    public void setCollaborationList(Collection<CollaborationSummary> collaborationList) {
        if (collaborationList == null) {
            this.collaborationList = null;
            return;
        }
        this.collaborationList = new ArrayList<CollaborationSummary>(collaborationList);
    }

    public ListCollaborationsResult withCollaborationList(CollaborationSummary ... collaborationList) {
        if (this.collaborationList == null) {
            this.setCollaborationList(new ArrayList<CollaborationSummary>(collaborationList.length));
        }
        for (CollaborationSummary ele : collaborationList) {
            this.collaborationList.add(ele);
        }
        return this;
    }

    public ListCollaborationsResult withCollaborationList(Collection<CollaborationSummary> collaborationList) {
        this.setCollaborationList(collaborationList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getCollaborationList() != null) {
            sb.append("CollaborationList: ").append(this.getCollaborationList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCollaborationsResult)) {
            return false;
        }
        ListCollaborationsResult other = (ListCollaborationsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getCollaborationList() == null ^ this.getCollaborationList() == null) {
            return false;
        }
        return other.getCollaborationList() == null || other.getCollaborationList().equals(this.getCollaborationList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getCollaborationList() == null ? 0 : this.getCollaborationList().hashCode());
        return hashCode;
    }

    public ListCollaborationsResult clone() {
        try {
            return (ListCollaborationsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

