/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chimesdkvoice.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.chimesdkvoice.model.MediaInsightsConfiguration;
import com.amazonaws.services.chimesdkvoice.model.StreamingNotificationTarget;
import com.amazonaws.services.chimesdkvoice.model.transform.StreamingConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StreamingConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer dataRetentionInHours;
    private Boolean disabled;
    private List<StreamingNotificationTarget> streamingNotificationTargets;
    private MediaInsightsConfiguration mediaInsightsConfiguration;

    public void setDataRetentionInHours(Integer dataRetentionInHours) {
        this.dataRetentionInHours = dataRetentionInHours;
    }

    public Integer getDataRetentionInHours() {
        return this.dataRetentionInHours;
    }

    public StreamingConfiguration withDataRetentionInHours(Integer dataRetentionInHours) {
        this.setDataRetentionInHours(dataRetentionInHours);
        return this;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public StreamingConfiguration withDisabled(Boolean disabled) {
        this.setDisabled(disabled);
        return this;
    }

    public Boolean isDisabled() {
        return this.disabled;
    }

    public List<StreamingNotificationTarget> getStreamingNotificationTargets() {
        return this.streamingNotificationTargets;
    }

    public void setStreamingNotificationTargets(Collection<StreamingNotificationTarget> streamingNotificationTargets) {
        if (streamingNotificationTargets == null) {
            this.streamingNotificationTargets = null;
            return;
        }
        this.streamingNotificationTargets = new ArrayList<StreamingNotificationTarget>(streamingNotificationTargets);
    }

    public StreamingConfiguration withStreamingNotificationTargets(StreamingNotificationTarget ... streamingNotificationTargets) {
        if (this.streamingNotificationTargets == null) {
            this.setStreamingNotificationTargets(new ArrayList<StreamingNotificationTarget>(streamingNotificationTargets.length));
        }
        for (StreamingNotificationTarget ele : streamingNotificationTargets) {
            this.streamingNotificationTargets.add(ele);
        }
        return this;
    }

    public StreamingConfiguration withStreamingNotificationTargets(Collection<StreamingNotificationTarget> streamingNotificationTargets) {
        this.setStreamingNotificationTargets(streamingNotificationTargets);
        return this;
    }

    public void setMediaInsightsConfiguration(MediaInsightsConfiguration mediaInsightsConfiguration) {
        this.mediaInsightsConfiguration = mediaInsightsConfiguration;
    }

    public MediaInsightsConfiguration getMediaInsightsConfiguration() {
        return this.mediaInsightsConfiguration;
    }

    public StreamingConfiguration withMediaInsightsConfiguration(MediaInsightsConfiguration mediaInsightsConfiguration) {
        this.setMediaInsightsConfiguration(mediaInsightsConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDataRetentionInHours() != null) {
            sb.append("DataRetentionInHours: ").append(this.getDataRetentionInHours()).append(",");
        }
        if (this.getDisabled() != null) {
            sb.append("Disabled: ").append(this.getDisabled()).append(",");
        }
        if (this.getStreamingNotificationTargets() != null) {
            sb.append("StreamingNotificationTargets: ").append(this.getStreamingNotificationTargets()).append(",");
        }
        if (this.getMediaInsightsConfiguration() != null) {
            sb.append("MediaInsightsConfiguration: ").append(this.getMediaInsightsConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingConfiguration)) {
            return false;
        }
        StreamingConfiguration other = (StreamingConfiguration)obj;
        if (other.getDataRetentionInHours() == null ^ this.getDataRetentionInHours() == null) {
            return false;
        }
        if (other.getDataRetentionInHours() != null && !other.getDataRetentionInHours().equals(this.getDataRetentionInHours())) {
            return false;
        }
        if (other.getDisabled() == null ^ this.getDisabled() == null) {
            return false;
        }
        if (other.getDisabled() != null && !other.getDisabled().equals(this.getDisabled())) {
            return false;
        }
        if (other.getStreamingNotificationTargets() == null ^ this.getStreamingNotificationTargets() == null) {
            return false;
        }
        if (other.getStreamingNotificationTargets() != null && !other.getStreamingNotificationTargets().equals(this.getStreamingNotificationTargets())) {
            return false;
        }
        if (other.getMediaInsightsConfiguration() == null ^ this.getMediaInsightsConfiguration() == null) {
            return false;
        }
        return other.getMediaInsightsConfiguration() == null || other.getMediaInsightsConfiguration().equals(this.getMediaInsightsConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDataRetentionInHours() == null ? 0 : this.getDataRetentionInHours().hashCode());
        hashCode = 31 * hashCode + (this.getDisabled() == null ? 0 : this.getDisabled().hashCode());
        hashCode = 31 * hashCode + (this.getStreamingNotificationTargets() == null ? 0 : this.getStreamingNotificationTargets().hashCode());
        hashCode = 31 * hashCode + (this.getMediaInsightsConfiguration() == null ? 0 : this.getMediaInsightsConfiguration().hashCode());
        return hashCode;
    }

    public StreamingConfiguration clone() {
        try {
            return (StreamingConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StreamingConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

