/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chimesdkmessaging.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.chimesdkmessaging.model.ChannelMessageStatusStructure;
import com.amazonaws.services.chimesdkmessaging.model.ChannelMessageType;
import com.amazonaws.services.chimesdkmessaging.model.Identity;
import com.amazonaws.services.chimesdkmessaging.model.MessageAttributeValue;
import com.amazonaws.services.chimesdkmessaging.model.transform.ChannelMessageSummaryMarshaller;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ChannelMessageSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private String messageId;
    private String content;
    private String metadata;
    private String type;
    private Date createdTimestamp;
    private Date lastUpdatedTimestamp;
    private Date lastEditedTimestamp;
    private Identity sender;
    private Boolean redacted;
    private ChannelMessageStatusStructure status;
    private Map<String, MessageAttributeValue> messageAttributes;

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public ChannelMessageSummary withMessageId(String messageId) {
        this.setMessageId(messageId);
        return this;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContent() {
        return this.content;
    }

    public ChannelMessageSummary withContent(String content) {
        this.setContent(content);
        return this;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public ChannelMessageSummary withMetadata(String metadata) {
        this.setMetadata(metadata);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public ChannelMessageSummary withType(String type) {
        this.setType(type);
        return this;
    }

    public ChannelMessageSummary withType(ChannelMessageType type) {
        this.type = type.toString();
        return this;
    }

    public void setCreatedTimestamp(Date createdTimestamp) {
        this.createdTimestamp = createdTimestamp;
    }

    public Date getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public ChannelMessageSummary withCreatedTimestamp(Date createdTimestamp) {
        this.setCreatedTimestamp(createdTimestamp);
        return this;
    }

    public void setLastUpdatedTimestamp(Date lastUpdatedTimestamp) {
        this.lastUpdatedTimestamp = lastUpdatedTimestamp;
    }

    public Date getLastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public ChannelMessageSummary withLastUpdatedTimestamp(Date lastUpdatedTimestamp) {
        this.setLastUpdatedTimestamp(lastUpdatedTimestamp);
        return this;
    }

    public void setLastEditedTimestamp(Date lastEditedTimestamp) {
        this.lastEditedTimestamp = lastEditedTimestamp;
    }

    public Date getLastEditedTimestamp() {
        return this.lastEditedTimestamp;
    }

    public ChannelMessageSummary withLastEditedTimestamp(Date lastEditedTimestamp) {
        this.setLastEditedTimestamp(lastEditedTimestamp);
        return this;
    }

    public void setSender(Identity sender) {
        this.sender = sender;
    }

    public Identity getSender() {
        return this.sender;
    }

    public ChannelMessageSummary withSender(Identity sender) {
        this.setSender(sender);
        return this;
    }

    public void setRedacted(Boolean redacted) {
        this.redacted = redacted;
    }

    public Boolean getRedacted() {
        return this.redacted;
    }

    public ChannelMessageSummary withRedacted(Boolean redacted) {
        this.setRedacted(redacted);
        return this;
    }

    public Boolean isRedacted() {
        return this.redacted;
    }

    public void setStatus(ChannelMessageStatusStructure status) {
        this.status = status;
    }

    public ChannelMessageStatusStructure getStatus() {
        return this.status;
    }

    public ChannelMessageSummary withStatus(ChannelMessageStatusStructure status) {
        this.setStatus(status);
        return this;
    }

    public Map<String, MessageAttributeValue> getMessageAttributes() {
        return this.messageAttributes;
    }

    public void setMessageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
        this.messageAttributes = messageAttributes;
    }

    public ChannelMessageSummary withMessageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
        this.setMessageAttributes(messageAttributes);
        return this;
    }

    public ChannelMessageSummary addMessageAttributesEntry(String key, MessageAttributeValue value) {
        if (null == this.messageAttributes) {
            this.messageAttributes = new HashMap<String, MessageAttributeValue>();
        }
        if (this.messageAttributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.messageAttributes.put(key, value);
        return this;
    }

    public ChannelMessageSummary clearMessageAttributesEntries() {
        this.messageAttributes = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMessageId() != null) {
            sb.append("MessageId: ").append(this.getMessageId()).append(",");
        }
        if (this.getContent() != null) {
            sb.append("Content: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getMetadata() != null) {
            sb.append("Metadata: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getCreatedTimestamp() != null) {
            sb.append("CreatedTimestamp: ").append(this.getCreatedTimestamp()).append(",");
        }
        if (this.getLastUpdatedTimestamp() != null) {
            sb.append("LastUpdatedTimestamp: ").append(this.getLastUpdatedTimestamp()).append(",");
        }
        if (this.getLastEditedTimestamp() != null) {
            sb.append("LastEditedTimestamp: ").append(this.getLastEditedTimestamp()).append(",");
        }
        if (this.getSender() != null) {
            sb.append("Sender: ").append(this.getSender()).append(",");
        }
        if (this.getRedacted() != null) {
            sb.append("Redacted: ").append(this.getRedacted()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getMessageAttributes() != null) {
            sb.append("MessageAttributes: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelMessageSummary)) {
            return false;
        }
        ChannelMessageSummary other = (ChannelMessageSummary)obj;
        if (other.getMessageId() == null ^ this.getMessageId() == null) {
            return false;
        }
        if (other.getMessageId() != null && !other.getMessageId().equals(this.getMessageId())) {
            return false;
        }
        if (other.getContent() == null ^ this.getContent() == null) {
            return false;
        }
        if (other.getContent() != null && !other.getContent().equals(this.getContent())) {
            return false;
        }
        if (other.getMetadata() == null ^ this.getMetadata() == null) {
            return false;
        }
        if (other.getMetadata() != null && !other.getMetadata().equals(this.getMetadata())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getCreatedTimestamp() == null ^ this.getCreatedTimestamp() == null) {
            return false;
        }
        if (other.getCreatedTimestamp() != null && !other.getCreatedTimestamp().equals(this.getCreatedTimestamp())) {
            return false;
        }
        if (other.getLastUpdatedTimestamp() == null ^ this.getLastUpdatedTimestamp() == null) {
            return false;
        }
        if (other.getLastUpdatedTimestamp() != null && !other.getLastUpdatedTimestamp().equals(this.getLastUpdatedTimestamp())) {
            return false;
        }
        if (other.getLastEditedTimestamp() == null ^ this.getLastEditedTimestamp() == null) {
            return false;
        }
        if (other.getLastEditedTimestamp() != null && !other.getLastEditedTimestamp().equals(this.getLastEditedTimestamp())) {
            return false;
        }
        if (other.getSender() == null ^ this.getSender() == null) {
            return false;
        }
        if (other.getSender() != null && !other.getSender().equals(this.getSender())) {
            return false;
        }
        if (other.getRedacted() == null ^ this.getRedacted() == null) {
            return false;
        }
        if (other.getRedacted() != null && !other.getRedacted().equals(this.getRedacted())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getMessageAttributes() == null ^ this.getMessageAttributes() == null) {
            return false;
        }
        return other.getMessageAttributes() == null || other.getMessageAttributes().equals(this.getMessageAttributes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMessageId() == null ? 0 : this.getMessageId().hashCode());
        hashCode = 31 * hashCode + (this.getContent() == null ? 0 : this.getContent().hashCode());
        hashCode = 31 * hashCode + (this.getMetadata() == null ? 0 : this.getMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTimestamp() == null ? 0 : this.getCreatedTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedTimestamp() == null ? 0 : this.getLastUpdatedTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getLastEditedTimestamp() == null ? 0 : this.getLastEditedTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getSender() == null ? 0 : this.getSender().hashCode());
        hashCode = 31 * hashCode + (this.getRedacted() == null ? 0 : this.getRedacted().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getMessageAttributes() == null ? 0 : this.getMessageAttributes().hashCode());
        return hashCode;
    }

    public ChannelMessageSummary clone() {
        try {
            return (ChannelMessageSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ChannelMessageSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

