/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.chime.model.Meeting;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListMeetingsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Meeting> meetings;
    private String nextToken;

    public List<Meeting> getMeetings() {
        return this.meetings;
    }

    public void setMeetings(Collection<Meeting> meetings) {
        if (meetings == null) {
            this.meetings = null;
            return;
        }
        this.meetings = new ArrayList<Meeting>(meetings);
    }

    public ListMeetingsResult withMeetings(Meeting ... meetings) {
        if (this.meetings == null) {
            this.setMeetings(new ArrayList<Meeting>(meetings.length));
        }
        for (Meeting ele : meetings) {
            this.meetings.add(ele);
        }
        return this;
    }

    public ListMeetingsResult withMeetings(Collection<Meeting> meetings) {
        this.setMeetings(meetings);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListMeetingsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMeetings() != null) {
            sb.append("Meetings: ").append(this.getMeetings()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMeetingsResult)) {
            return false;
        }
        ListMeetingsResult other = (ListMeetingsResult)obj;
        if (other.getMeetings() == null ^ this.getMeetings() == null) {
            return false;
        }
        if (other.getMeetings() != null && !other.getMeetings().equals(this.getMeetings())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMeetings() == null ? 0 : this.getMeetings().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListMeetingsResult clone() {
        try {
            return (ListMeetingsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

