/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.budgets;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.budgets.AWSBudgets;
import com.amazonaws.services.budgets.AWSBudgetsClientBuilder;
import com.amazonaws.services.budgets.model.AWSBudgetsException;
import com.amazonaws.services.budgets.model.CreateBudgetActionRequest;
import com.amazonaws.services.budgets.model.CreateBudgetActionResult;
import com.amazonaws.services.budgets.model.CreateBudgetRequest;
import com.amazonaws.services.budgets.model.CreateBudgetResult;
import com.amazonaws.services.budgets.model.CreateNotificationRequest;
import com.amazonaws.services.budgets.model.CreateNotificationResult;
import com.amazonaws.services.budgets.model.CreateSubscriberRequest;
import com.amazonaws.services.budgets.model.CreateSubscriberResult;
import com.amazonaws.services.budgets.model.DeleteBudgetActionRequest;
import com.amazonaws.services.budgets.model.DeleteBudgetActionResult;
import com.amazonaws.services.budgets.model.DeleteBudgetRequest;
import com.amazonaws.services.budgets.model.DeleteBudgetResult;
import com.amazonaws.services.budgets.model.DeleteNotificationRequest;
import com.amazonaws.services.budgets.model.DeleteNotificationResult;
import com.amazonaws.services.budgets.model.DeleteSubscriberRequest;
import com.amazonaws.services.budgets.model.DeleteSubscriberResult;
import com.amazonaws.services.budgets.model.DescribeBudgetActionHistoriesRequest;
import com.amazonaws.services.budgets.model.DescribeBudgetActionHistoriesResult;
import com.amazonaws.services.budgets.model.DescribeBudgetActionRequest;
import com.amazonaws.services.budgets.model.DescribeBudgetActionResult;
import com.amazonaws.services.budgets.model.DescribeBudgetActionsForAccountRequest;
import com.amazonaws.services.budgets.model.DescribeBudgetActionsForAccountResult;
import com.amazonaws.services.budgets.model.DescribeBudgetActionsForBudgetRequest;
import com.amazonaws.services.budgets.model.DescribeBudgetActionsForBudgetResult;
import com.amazonaws.services.budgets.model.DescribeBudgetNotificationsForAccountRequest;
import com.amazonaws.services.budgets.model.DescribeBudgetNotificationsForAccountResult;
import com.amazonaws.services.budgets.model.DescribeBudgetPerformanceHistoryRequest;
import com.amazonaws.services.budgets.model.DescribeBudgetPerformanceHistoryResult;
import com.amazonaws.services.budgets.model.DescribeBudgetRequest;
import com.amazonaws.services.budgets.model.DescribeBudgetResult;
import com.amazonaws.services.budgets.model.DescribeBudgetsRequest;
import com.amazonaws.services.budgets.model.DescribeBudgetsResult;
import com.amazonaws.services.budgets.model.DescribeNotificationsForBudgetRequest;
import com.amazonaws.services.budgets.model.DescribeNotificationsForBudgetResult;
import com.amazonaws.services.budgets.model.DescribeSubscribersForNotificationRequest;
import com.amazonaws.services.budgets.model.DescribeSubscribersForNotificationResult;
import com.amazonaws.services.budgets.model.ExecuteBudgetActionRequest;
import com.amazonaws.services.budgets.model.ExecuteBudgetActionResult;
import com.amazonaws.services.budgets.model.ListTagsForResourceRequest;
import com.amazonaws.services.budgets.model.ListTagsForResourceResult;
import com.amazonaws.services.budgets.model.TagResourceRequest;
import com.amazonaws.services.budgets.model.TagResourceResult;
import com.amazonaws.services.budgets.model.UntagResourceRequest;
import com.amazonaws.services.budgets.model.UntagResourceResult;
import com.amazonaws.services.budgets.model.UpdateBudgetActionRequest;
import com.amazonaws.services.budgets.model.UpdateBudgetActionResult;
import com.amazonaws.services.budgets.model.UpdateBudgetRequest;
import com.amazonaws.services.budgets.model.UpdateBudgetResult;
import com.amazonaws.services.budgets.model.UpdateNotificationRequest;
import com.amazonaws.services.budgets.model.UpdateNotificationResult;
import com.amazonaws.services.budgets.model.UpdateSubscriberRequest;
import com.amazonaws.services.budgets.model.UpdateSubscriberResult;
import com.amazonaws.services.budgets.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.budgets.model.transform.CreateBudgetActionRequestProtocolMarshaller;
import com.amazonaws.services.budgets.model.transform.CreateBudgetActionResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.CreateBudgetRequestProtocolMarshaller;
import com.amazonaws.services.budgets.model.transform.CreateBudgetResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.CreateNotificationRequestProtocolMarshaller;
import com.amazonaws.services.budgets.model.transform.CreateNotificationResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.CreateSubscriberRequestProtocolMarshaller;
import com.amazonaws.services.budgets.model.transform.CreateSubscriberResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.CreationLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.budgets.model.transform.DeleteBudgetActionRequestProtocolMarshaller;
import com.amazonaws.services.budgets.model.transform.DeleteBudgetActionResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.DeleteBudgetRequestProtocolMarshaller;
import com.amazonaws.services.budgets.model.transform.DeleteBudgetResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.DeleteNotificationRequestProtocolMarshaller;
import com.amazonaws.services.budgets.model.transform.DeleteNotificationResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.DeleteSubscriberRequestProtocolMarshaller;
import com.amazonaws.services.budgets.model.transform.DeleteSubscriberResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.DescribeBudgetActionHistoriesRequestProtocolMarshaller;
import com.amazonaws.services.budgets.model.transform.DescribeBudgetActionHistoriesResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.DescribeBudgetActionRequestProtocolMarshaller;
import com.amazonaws.services.budgets.model.transform.DescribeBudgetActionResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.DescribeBudgetActionsForAccountRequestProtocolMarshaller;
import com.amazonaws.services.budgets.model.transform.DescribeBudgetActionsForAccountResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.DescribeBudgetActionsForBudgetRequestProtocolMarshaller;
import com.amazonaws.services.budgets.model.transform.DescribeBudgetActionsForBudgetResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.DescribeBudgetNotificationsForAccountRequestProtocolMarshaller;
import com.amazonaws.services.budgets.model.transform.DescribeBudgetNotificationsForAccountResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.DescribeBudgetPerformanceHistoryRequestProtocolMarshaller;
import com.amazonaws.services.budgets.model.transform.DescribeBudgetPerformanceHistoryResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.DescribeBudgetRequestProtocolMarshaller;
import com.amazonaws.services.budgets.model.transform.DescribeBudgetResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.DescribeBudgetsRequestProtocolMarshaller;
import com.amazonaws.services.budgets.model.transform.DescribeBudgetsResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.DescribeNotificationsForBudgetRequestProtocolMarshaller;
import com.amazonaws.services.budgets.model.transform.DescribeNotificationsForBudgetResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.DescribeSubscribersForNotificationRequestProtocolMarshaller;
import com.amazonaws.services.budgets.model.transform.DescribeSubscribersForNotificationResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.DuplicateRecordExceptionUnmarshaller;
import com.amazonaws.services.budgets.model.transform.ExecuteBudgetActionRequestProtocolMarshaller;
import com.amazonaws.services.budgets.model.transform.ExecuteBudgetActionResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.ExpiredNextTokenExceptionUnmarshaller;
import com.amazonaws.services.budgets.model.transform.InternalErrorExceptionUnmarshaller;
import com.amazonaws.services.budgets.model.transform.InvalidNextTokenExceptionUnmarshaller;
import com.amazonaws.services.budgets.model.transform.InvalidParameterExceptionUnmarshaller;
import com.amazonaws.services.budgets.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.budgets.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.NotFoundExceptionUnmarshaller;
import com.amazonaws.services.budgets.model.transform.ResourceLockedExceptionUnmarshaller;
import com.amazonaws.services.budgets.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.budgets.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.budgets.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.budgets.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.budgets.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.UpdateBudgetActionRequestProtocolMarshaller;
import com.amazonaws.services.budgets.model.transform.UpdateBudgetActionResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.UpdateBudgetRequestProtocolMarshaller;
import com.amazonaws.services.budgets.model.transform.UpdateBudgetResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.UpdateNotificationRequestProtocolMarshaller;
import com.amazonaws.services.budgets.model.transform.UpdateNotificationResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.UpdateSubscriberRequestProtocolMarshaller;
import com.amazonaws.services.budgets.model.transform.UpdateSubscriberResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSBudgetsClient
extends AmazonWebServiceClient
implements AWSBudgets {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSBudgets.class);
    private static final String DEFAULT_SIGNING_NAME = "budgets";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidParameterExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)NotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DuplicateRecordException").withExceptionUnmarshaller((JsonErrorUnmarshaller)DuplicateRecordExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalErrorException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalErrorExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CreationLimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)CreationLimitExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidNextTokenExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ExpiredNextTokenException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ExpiredNextTokenExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceLockedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceLockedExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSBudgetsException.class));

    @Deprecated
    public AWSBudgetsClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AWSBudgetsClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AWSBudgetsClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AWSBudgetsClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.advancedConfig = AdvancedConfig.EMPTY;
        this.init();
    }

    @Deprecated
    public AWSBudgetsClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AWSBudgetsClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AWSBudgetsClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.advancedConfig = AdvancedConfig.EMPTY;
        this.init();
    }

    public static AWSBudgetsClientBuilder builder() {
        return AWSBudgetsClientBuilder.standard();
    }

    AWSBudgetsClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSBudgetsClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("budgets.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/budgets/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/budgets/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateBudgetResult createBudget(CreateBudgetRequest request) {
        request = (CreateBudgetRequest)this.beforeClientExecution(request);
        return this.executeCreateBudget(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateBudgetResult executeCreateBudget(CreateBudgetRequest createBudgetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createBudgetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateBudgetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateBudgetRequestProtocolMarshaller(protocolFactory).marshall((CreateBudgetRequest)super.beforeMarshalling((AmazonWebServiceRequest)createBudgetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Budgets");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateBudget");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateBudgetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateBudgetResult createBudgetResult = (CreateBudgetResult)response.getAwsResponse();
            return createBudgetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateBudgetActionResult createBudgetAction(CreateBudgetActionRequest request) {
        request = (CreateBudgetActionRequest)this.beforeClientExecution(request);
        return this.executeCreateBudgetAction(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateBudgetActionResult executeCreateBudgetAction(CreateBudgetActionRequest createBudgetActionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createBudgetActionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateBudgetActionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateBudgetActionRequestProtocolMarshaller(protocolFactory).marshall((CreateBudgetActionRequest)super.beforeMarshalling((AmazonWebServiceRequest)createBudgetActionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Budgets");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateBudgetAction");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateBudgetActionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateBudgetActionResult createBudgetActionResult = (CreateBudgetActionResult)response.getAwsResponse();
            return createBudgetActionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateNotificationResult createNotification(CreateNotificationRequest request) {
        request = (CreateNotificationRequest)this.beforeClientExecution(request);
        return this.executeCreateNotification(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateNotificationResult executeCreateNotification(CreateNotificationRequest createNotificationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createNotificationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateNotificationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateNotificationRequestProtocolMarshaller(protocolFactory).marshall((CreateNotificationRequest)super.beforeMarshalling((AmazonWebServiceRequest)createNotificationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Budgets");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateNotification");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateNotificationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateNotificationResult createNotificationResult = (CreateNotificationResult)response.getAwsResponse();
            return createNotificationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateSubscriberResult createSubscriber(CreateSubscriberRequest request) {
        request = (CreateSubscriberRequest)this.beforeClientExecution(request);
        return this.executeCreateSubscriber(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateSubscriberResult executeCreateSubscriber(CreateSubscriberRequest createSubscriberRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createSubscriberRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateSubscriberRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateSubscriberRequestProtocolMarshaller(protocolFactory).marshall((CreateSubscriberRequest)super.beforeMarshalling((AmazonWebServiceRequest)createSubscriberRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Budgets");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateSubscriber");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateSubscriberResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateSubscriberResult createSubscriberResult = (CreateSubscriberResult)response.getAwsResponse();
            return createSubscriberResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteBudgetResult deleteBudget(DeleteBudgetRequest request) {
        request = (DeleteBudgetRequest)this.beforeClientExecution(request);
        return this.executeDeleteBudget(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteBudgetResult executeDeleteBudget(DeleteBudgetRequest deleteBudgetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteBudgetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteBudgetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteBudgetRequestProtocolMarshaller(protocolFactory).marshall((DeleteBudgetRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteBudgetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Budgets");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteBudget");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteBudgetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteBudgetResult deleteBudgetResult = (DeleteBudgetResult)response.getAwsResponse();
            return deleteBudgetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteBudgetActionResult deleteBudgetAction(DeleteBudgetActionRequest request) {
        request = (DeleteBudgetActionRequest)this.beforeClientExecution(request);
        return this.executeDeleteBudgetAction(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteBudgetActionResult executeDeleteBudgetAction(DeleteBudgetActionRequest deleteBudgetActionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteBudgetActionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteBudgetActionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteBudgetActionRequestProtocolMarshaller(protocolFactory).marshall((DeleteBudgetActionRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteBudgetActionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Budgets");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteBudgetAction");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteBudgetActionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteBudgetActionResult deleteBudgetActionResult = (DeleteBudgetActionResult)response.getAwsResponse();
            return deleteBudgetActionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteNotificationResult deleteNotification(DeleteNotificationRequest request) {
        request = (DeleteNotificationRequest)this.beforeClientExecution(request);
        return this.executeDeleteNotification(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteNotificationResult executeDeleteNotification(DeleteNotificationRequest deleteNotificationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteNotificationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteNotificationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteNotificationRequestProtocolMarshaller(protocolFactory).marshall((DeleteNotificationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteNotificationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Budgets");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteNotification");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteNotificationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteNotificationResult deleteNotificationResult = (DeleteNotificationResult)response.getAwsResponse();
            return deleteNotificationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteSubscriberResult deleteSubscriber(DeleteSubscriberRequest request) {
        request = (DeleteSubscriberRequest)this.beforeClientExecution(request);
        return this.executeDeleteSubscriber(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteSubscriberResult executeDeleteSubscriber(DeleteSubscriberRequest deleteSubscriberRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteSubscriberRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteSubscriberRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteSubscriberRequestProtocolMarshaller(protocolFactory).marshall((DeleteSubscriberRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteSubscriberRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Budgets");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteSubscriber");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteSubscriberResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteSubscriberResult deleteSubscriberResult = (DeleteSubscriberResult)response.getAwsResponse();
            return deleteSubscriberResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeBudgetResult describeBudget(DescribeBudgetRequest request) {
        request = (DescribeBudgetRequest)this.beforeClientExecution(request);
        return this.executeDescribeBudget(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeBudgetResult executeDescribeBudget(DescribeBudgetRequest describeBudgetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeBudgetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeBudgetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeBudgetRequestProtocolMarshaller(protocolFactory).marshall((DescribeBudgetRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeBudgetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Budgets");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeBudget");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeBudgetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeBudgetResult describeBudgetResult = (DescribeBudgetResult)response.getAwsResponse();
            return describeBudgetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeBudgetActionResult describeBudgetAction(DescribeBudgetActionRequest request) {
        request = (DescribeBudgetActionRequest)this.beforeClientExecution(request);
        return this.executeDescribeBudgetAction(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeBudgetActionResult executeDescribeBudgetAction(DescribeBudgetActionRequest describeBudgetActionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeBudgetActionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeBudgetActionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeBudgetActionRequestProtocolMarshaller(protocolFactory).marshall((DescribeBudgetActionRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeBudgetActionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Budgets");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeBudgetAction");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeBudgetActionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeBudgetActionResult describeBudgetActionResult = (DescribeBudgetActionResult)response.getAwsResponse();
            return describeBudgetActionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeBudgetActionHistoriesResult describeBudgetActionHistories(DescribeBudgetActionHistoriesRequest request) {
        request = (DescribeBudgetActionHistoriesRequest)this.beforeClientExecution(request);
        return this.executeDescribeBudgetActionHistories(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeBudgetActionHistoriesResult executeDescribeBudgetActionHistories(DescribeBudgetActionHistoriesRequest describeBudgetActionHistoriesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeBudgetActionHistoriesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeBudgetActionHistoriesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeBudgetActionHistoriesRequestProtocolMarshaller(protocolFactory).marshall((DescribeBudgetActionHistoriesRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeBudgetActionHistoriesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Budgets");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeBudgetActionHistories");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeBudgetActionHistoriesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeBudgetActionHistoriesResult describeBudgetActionHistoriesResult = (DescribeBudgetActionHistoriesResult)response.getAwsResponse();
            return describeBudgetActionHistoriesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeBudgetActionsForAccountResult describeBudgetActionsForAccount(DescribeBudgetActionsForAccountRequest request) {
        request = (DescribeBudgetActionsForAccountRequest)this.beforeClientExecution(request);
        return this.executeDescribeBudgetActionsForAccount(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeBudgetActionsForAccountResult executeDescribeBudgetActionsForAccount(DescribeBudgetActionsForAccountRequest describeBudgetActionsForAccountRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeBudgetActionsForAccountRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeBudgetActionsForAccountRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeBudgetActionsForAccountRequestProtocolMarshaller(protocolFactory).marshall((DescribeBudgetActionsForAccountRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeBudgetActionsForAccountRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Budgets");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeBudgetActionsForAccount");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeBudgetActionsForAccountResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeBudgetActionsForAccountResult describeBudgetActionsForAccountResult = (DescribeBudgetActionsForAccountResult)response.getAwsResponse();
            return describeBudgetActionsForAccountResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeBudgetActionsForBudgetResult describeBudgetActionsForBudget(DescribeBudgetActionsForBudgetRequest request) {
        request = (DescribeBudgetActionsForBudgetRequest)this.beforeClientExecution(request);
        return this.executeDescribeBudgetActionsForBudget(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeBudgetActionsForBudgetResult executeDescribeBudgetActionsForBudget(DescribeBudgetActionsForBudgetRequest describeBudgetActionsForBudgetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeBudgetActionsForBudgetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeBudgetActionsForBudgetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeBudgetActionsForBudgetRequestProtocolMarshaller(protocolFactory).marshall((DescribeBudgetActionsForBudgetRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeBudgetActionsForBudgetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Budgets");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeBudgetActionsForBudget");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeBudgetActionsForBudgetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeBudgetActionsForBudgetResult describeBudgetActionsForBudgetResult = (DescribeBudgetActionsForBudgetResult)response.getAwsResponse();
            return describeBudgetActionsForBudgetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeBudgetNotificationsForAccountResult describeBudgetNotificationsForAccount(DescribeBudgetNotificationsForAccountRequest request) {
        request = (DescribeBudgetNotificationsForAccountRequest)this.beforeClientExecution(request);
        return this.executeDescribeBudgetNotificationsForAccount(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeBudgetNotificationsForAccountResult executeDescribeBudgetNotificationsForAccount(DescribeBudgetNotificationsForAccountRequest describeBudgetNotificationsForAccountRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeBudgetNotificationsForAccountRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeBudgetNotificationsForAccountRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeBudgetNotificationsForAccountRequestProtocolMarshaller(protocolFactory).marshall((DescribeBudgetNotificationsForAccountRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeBudgetNotificationsForAccountRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Budgets");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeBudgetNotificationsForAccount");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeBudgetNotificationsForAccountResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeBudgetNotificationsForAccountResult describeBudgetNotificationsForAccountResult = (DescribeBudgetNotificationsForAccountResult)response.getAwsResponse();
            return describeBudgetNotificationsForAccountResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeBudgetPerformanceHistoryResult describeBudgetPerformanceHistory(DescribeBudgetPerformanceHistoryRequest request) {
        request = (DescribeBudgetPerformanceHistoryRequest)this.beforeClientExecution(request);
        return this.executeDescribeBudgetPerformanceHistory(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeBudgetPerformanceHistoryResult executeDescribeBudgetPerformanceHistory(DescribeBudgetPerformanceHistoryRequest describeBudgetPerformanceHistoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeBudgetPerformanceHistoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeBudgetPerformanceHistoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeBudgetPerformanceHistoryRequestProtocolMarshaller(protocolFactory).marshall((DescribeBudgetPerformanceHistoryRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeBudgetPerformanceHistoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Budgets");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeBudgetPerformanceHistory");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeBudgetPerformanceHistoryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeBudgetPerformanceHistoryResult describeBudgetPerformanceHistoryResult = (DescribeBudgetPerformanceHistoryResult)response.getAwsResponse();
            return describeBudgetPerformanceHistoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeBudgetsResult describeBudgets(DescribeBudgetsRequest request) {
        request = (DescribeBudgetsRequest)this.beforeClientExecution(request);
        return this.executeDescribeBudgets(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeBudgetsResult executeDescribeBudgets(DescribeBudgetsRequest describeBudgetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeBudgetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeBudgetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeBudgetsRequestProtocolMarshaller(protocolFactory).marshall((DescribeBudgetsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeBudgetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Budgets");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeBudgets");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeBudgetsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeBudgetsResult describeBudgetsResult = (DescribeBudgetsResult)response.getAwsResponse();
            return describeBudgetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeNotificationsForBudgetResult describeNotificationsForBudget(DescribeNotificationsForBudgetRequest request) {
        request = (DescribeNotificationsForBudgetRequest)this.beforeClientExecution(request);
        return this.executeDescribeNotificationsForBudget(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeNotificationsForBudgetResult executeDescribeNotificationsForBudget(DescribeNotificationsForBudgetRequest describeNotificationsForBudgetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeNotificationsForBudgetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeNotificationsForBudgetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeNotificationsForBudgetRequestProtocolMarshaller(protocolFactory).marshall((DescribeNotificationsForBudgetRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeNotificationsForBudgetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Budgets");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeNotificationsForBudget");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeNotificationsForBudgetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeNotificationsForBudgetResult describeNotificationsForBudgetResult = (DescribeNotificationsForBudgetResult)response.getAwsResponse();
            return describeNotificationsForBudgetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeSubscribersForNotificationResult describeSubscribersForNotification(DescribeSubscribersForNotificationRequest request) {
        request = (DescribeSubscribersForNotificationRequest)this.beforeClientExecution(request);
        return this.executeDescribeSubscribersForNotification(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeSubscribersForNotificationResult executeDescribeSubscribersForNotification(DescribeSubscribersForNotificationRequest describeSubscribersForNotificationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeSubscribersForNotificationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeSubscribersForNotificationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeSubscribersForNotificationRequestProtocolMarshaller(protocolFactory).marshall((DescribeSubscribersForNotificationRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeSubscribersForNotificationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Budgets");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeSubscribersForNotification");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeSubscribersForNotificationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeSubscribersForNotificationResult describeSubscribersForNotificationResult = (DescribeSubscribersForNotificationResult)response.getAwsResponse();
            return describeSubscribersForNotificationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ExecuteBudgetActionResult executeBudgetAction(ExecuteBudgetActionRequest request) {
        request = (ExecuteBudgetActionRequest)this.beforeClientExecution(request);
        return this.executeExecuteBudgetAction(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ExecuteBudgetActionResult executeExecuteBudgetAction(ExecuteBudgetActionRequest executeBudgetActionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(executeBudgetActionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ExecuteBudgetActionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ExecuteBudgetActionRequestProtocolMarshaller(protocolFactory).marshall((ExecuteBudgetActionRequest)super.beforeMarshalling((AmazonWebServiceRequest)executeBudgetActionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Budgets");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ExecuteBudgetAction");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ExecuteBudgetActionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ExecuteBudgetActionResult executeBudgetActionResult = (ExecuteBudgetActionResult)response.getAwsResponse();
            return executeBudgetActionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Budgets");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Budgets");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Budgets");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateBudgetResult updateBudget(UpdateBudgetRequest request) {
        request = (UpdateBudgetRequest)this.beforeClientExecution(request);
        return this.executeUpdateBudget(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateBudgetResult executeUpdateBudget(UpdateBudgetRequest updateBudgetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateBudgetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateBudgetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateBudgetRequestProtocolMarshaller(protocolFactory).marshall((UpdateBudgetRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateBudgetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Budgets");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateBudget");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateBudgetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateBudgetResult updateBudgetResult = (UpdateBudgetResult)response.getAwsResponse();
            return updateBudgetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateBudgetActionResult updateBudgetAction(UpdateBudgetActionRequest request) {
        request = (UpdateBudgetActionRequest)this.beforeClientExecution(request);
        return this.executeUpdateBudgetAction(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateBudgetActionResult executeUpdateBudgetAction(UpdateBudgetActionRequest updateBudgetActionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateBudgetActionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateBudgetActionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateBudgetActionRequestProtocolMarshaller(protocolFactory).marshall((UpdateBudgetActionRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateBudgetActionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Budgets");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateBudgetAction");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateBudgetActionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateBudgetActionResult updateBudgetActionResult = (UpdateBudgetActionResult)response.getAwsResponse();
            return updateBudgetActionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateNotificationResult updateNotification(UpdateNotificationRequest request) {
        request = (UpdateNotificationRequest)this.beforeClientExecution(request);
        return this.executeUpdateNotification(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateNotificationResult executeUpdateNotification(UpdateNotificationRequest updateNotificationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateNotificationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateNotificationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateNotificationRequestProtocolMarshaller(protocolFactory).marshall((UpdateNotificationRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateNotificationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Budgets");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateNotification");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateNotificationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateNotificationResult updateNotificationResult = (UpdateNotificationResult)response.getAwsResponse();
            return updateNotificationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateSubscriberResult updateSubscriber(UpdateSubscriberRequest request) {
        request = (UpdateSubscriberRequest)this.beforeClientExecution(request);
        return this.executeUpdateSubscriber(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateSubscriberResult executeUpdateSubscriber(UpdateSubscriberRequest updateSubscriberRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateSubscriberRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateSubscriberRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateSubscriberRequestProtocolMarshaller(protocolFactory).marshall((UpdateSubscriberRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateSubscriberRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Budgets");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateSubscriber");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateSubscriberResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateSubscriberResult updateSubscriberResult = (UpdateSubscriberResult)response.getAwsResponse();
            return updateSubscriberResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

