/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.billingconductor.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.billingconductor.model.CustomLineItemBillingPeriodRange;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchDisassociateResourcesFromCustomLineItemRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String targetArn;
    private List<String> resourceArns;
    private CustomLineItemBillingPeriodRange billingPeriodRange;

    public void setTargetArn(String targetArn) {
        this.targetArn = targetArn;
    }

    public String getTargetArn() {
        return this.targetArn;
    }

    public BatchDisassociateResourcesFromCustomLineItemRequest withTargetArn(String targetArn) {
        this.setTargetArn(targetArn);
        return this;
    }

    public List<String> getResourceArns() {
        return this.resourceArns;
    }

    public void setResourceArns(Collection<String> resourceArns) {
        if (resourceArns == null) {
            this.resourceArns = null;
            return;
        }
        this.resourceArns = new ArrayList<String>(resourceArns);
    }

    public BatchDisassociateResourcesFromCustomLineItemRequest withResourceArns(String ... resourceArns) {
        if (this.resourceArns == null) {
            this.setResourceArns(new ArrayList<String>(resourceArns.length));
        }
        for (String ele : resourceArns) {
            this.resourceArns.add(ele);
        }
        return this;
    }

    public BatchDisassociateResourcesFromCustomLineItemRequest withResourceArns(Collection<String> resourceArns) {
        this.setResourceArns(resourceArns);
        return this;
    }

    public void setBillingPeriodRange(CustomLineItemBillingPeriodRange billingPeriodRange) {
        this.billingPeriodRange = billingPeriodRange;
    }

    public CustomLineItemBillingPeriodRange getBillingPeriodRange() {
        return this.billingPeriodRange;
    }

    public BatchDisassociateResourcesFromCustomLineItemRequest withBillingPeriodRange(CustomLineItemBillingPeriodRange billingPeriodRange) {
        this.setBillingPeriodRange(billingPeriodRange);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTargetArn() != null) {
            sb.append("TargetArn: ").append(this.getTargetArn()).append(",");
        }
        if (this.getResourceArns() != null) {
            sb.append("ResourceArns: ").append(this.getResourceArns()).append(",");
        }
        if (this.getBillingPeriodRange() != null) {
            sb.append("BillingPeriodRange: ").append(this.getBillingPeriodRange());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDisassociateResourcesFromCustomLineItemRequest)) {
            return false;
        }
        BatchDisassociateResourcesFromCustomLineItemRequest other = (BatchDisassociateResourcesFromCustomLineItemRequest)obj;
        if (other.getTargetArn() == null ^ this.getTargetArn() == null) {
            return false;
        }
        if (other.getTargetArn() != null && !other.getTargetArn().equals(this.getTargetArn())) {
            return false;
        }
        if (other.getResourceArns() == null ^ this.getResourceArns() == null) {
            return false;
        }
        if (other.getResourceArns() != null && !other.getResourceArns().equals(this.getResourceArns())) {
            return false;
        }
        if (other.getBillingPeriodRange() == null ^ this.getBillingPeriodRange() == null) {
            return false;
        }
        return other.getBillingPeriodRange() == null || other.getBillingPeriodRange().equals(this.getBillingPeriodRange());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTargetArn() == null ? 0 : this.getTargetArn().hashCode());
        hashCode = 31 * hashCode + (this.getResourceArns() == null ? 0 : this.getResourceArns().hashCode());
        hashCode = 31 * hashCode + (this.getBillingPeriodRange() == null ? 0 : this.getBillingPeriodRange().hashCode());
        return hashCode;
    }

    public BatchDisassociateResourcesFromCustomLineItemRequest clone() {
        return (BatchDisassociateResourcesFromCustomLineItemRequest)super.clone();
    }
}

