/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backup.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.backup.model.DateRange;
import com.amazonaws.services.backup.model.transform.RecoveryPointSelectionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RecoveryPointSelection
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> vaultNames;
    private List<String> resourceIdentifiers;
    private DateRange dateRange;

    public List<String> getVaultNames() {
        return this.vaultNames;
    }

    public void setVaultNames(Collection<String> vaultNames) {
        if (vaultNames == null) {
            this.vaultNames = null;
            return;
        }
        this.vaultNames = new ArrayList<String>(vaultNames);
    }

    public RecoveryPointSelection withVaultNames(String ... vaultNames) {
        if (this.vaultNames == null) {
            this.setVaultNames(new ArrayList<String>(vaultNames.length));
        }
        for (String ele : vaultNames) {
            this.vaultNames.add(ele);
        }
        return this;
    }

    public RecoveryPointSelection withVaultNames(Collection<String> vaultNames) {
        this.setVaultNames(vaultNames);
        return this;
    }

    public List<String> getResourceIdentifiers() {
        return this.resourceIdentifiers;
    }

    public void setResourceIdentifiers(Collection<String> resourceIdentifiers) {
        if (resourceIdentifiers == null) {
            this.resourceIdentifiers = null;
            return;
        }
        this.resourceIdentifiers = new ArrayList<String>(resourceIdentifiers);
    }

    public RecoveryPointSelection withResourceIdentifiers(String ... resourceIdentifiers) {
        if (this.resourceIdentifiers == null) {
            this.setResourceIdentifiers(new ArrayList<String>(resourceIdentifiers.length));
        }
        for (String ele : resourceIdentifiers) {
            this.resourceIdentifiers.add(ele);
        }
        return this;
    }

    public RecoveryPointSelection withResourceIdentifiers(Collection<String> resourceIdentifiers) {
        this.setResourceIdentifiers(resourceIdentifiers);
        return this;
    }

    public void setDateRange(DateRange dateRange) {
        this.dateRange = dateRange;
    }

    public DateRange getDateRange() {
        return this.dateRange;
    }

    public RecoveryPointSelection withDateRange(DateRange dateRange) {
        this.setDateRange(dateRange);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVaultNames() != null) {
            sb.append("VaultNames: ").append(this.getVaultNames()).append(",");
        }
        if (this.getResourceIdentifiers() != null) {
            sb.append("ResourceIdentifiers: ").append(this.getResourceIdentifiers()).append(",");
        }
        if (this.getDateRange() != null) {
            sb.append("DateRange: ").append(this.getDateRange());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecoveryPointSelection)) {
            return false;
        }
        RecoveryPointSelection other = (RecoveryPointSelection)obj;
        if (other.getVaultNames() == null ^ this.getVaultNames() == null) {
            return false;
        }
        if (other.getVaultNames() != null && !other.getVaultNames().equals(this.getVaultNames())) {
            return false;
        }
        if (other.getResourceIdentifiers() == null ^ this.getResourceIdentifiers() == null) {
            return false;
        }
        if (other.getResourceIdentifiers() != null && !other.getResourceIdentifiers().equals(this.getResourceIdentifiers())) {
            return false;
        }
        if (other.getDateRange() == null ^ this.getDateRange() == null) {
            return false;
        }
        return other.getDateRange() == null || other.getDateRange().equals(this.getDateRange());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVaultNames() == null ? 0 : this.getVaultNames().hashCode());
        hashCode = 31 * hashCode + (this.getResourceIdentifiers() == null ? 0 : this.getResourceIdentifiers().hashCode());
        hashCode = 31 * hashCode + (this.getDateRange() == null ? 0 : this.getDateRange().hashCode());
        return hashCode;
    }

    public RecoveryPointSelection clone() {
        try {
            return (RecoveryPointSelection)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecoveryPointSelectionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

