/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auditmanager.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.auditmanager.model.Resource;
import com.amazonaws.services.auditmanager.model.transform.EvidenceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Evidence
implements Serializable,
Cloneable,
StructuredPojo {
    private String dataSource;
    private String evidenceAwsAccountId;
    private Date time;
    private String eventSource;
    private String eventName;
    private String evidenceByType;
    private List<Resource> resourcesIncluded;
    private Map<String, String> attributes;
    private String iamId;
    private String complianceCheck;
    private String awsOrganization;
    private String awsAccountId;
    private String evidenceFolderId;
    private String id;
    private String assessmentReportSelection;

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public Evidence withDataSource(String dataSource) {
        this.setDataSource(dataSource);
        return this;
    }

    public void setEvidenceAwsAccountId(String evidenceAwsAccountId) {
        this.evidenceAwsAccountId = evidenceAwsAccountId;
    }

    public String getEvidenceAwsAccountId() {
        return this.evidenceAwsAccountId;
    }

    public Evidence withEvidenceAwsAccountId(String evidenceAwsAccountId) {
        this.setEvidenceAwsAccountId(evidenceAwsAccountId);
        return this;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public Date getTime() {
        return this.time;
    }

    public Evidence withTime(Date time) {
        this.setTime(time);
        return this;
    }

    public void setEventSource(String eventSource) {
        this.eventSource = eventSource;
    }

    public String getEventSource() {
        return this.eventSource;
    }

    public Evidence withEventSource(String eventSource) {
        this.setEventSource(eventSource);
        return this;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public String getEventName() {
        return this.eventName;
    }

    public Evidence withEventName(String eventName) {
        this.setEventName(eventName);
        return this;
    }

    public void setEvidenceByType(String evidenceByType) {
        this.evidenceByType = evidenceByType;
    }

    public String getEvidenceByType() {
        return this.evidenceByType;
    }

    public Evidence withEvidenceByType(String evidenceByType) {
        this.setEvidenceByType(evidenceByType);
        return this;
    }

    public List<Resource> getResourcesIncluded() {
        return this.resourcesIncluded;
    }

    public void setResourcesIncluded(Collection<Resource> resourcesIncluded) {
        if (resourcesIncluded == null) {
            this.resourcesIncluded = null;
            return;
        }
        this.resourcesIncluded = new ArrayList<Resource>(resourcesIncluded);
    }

    public Evidence withResourcesIncluded(Resource ... resourcesIncluded) {
        if (this.resourcesIncluded == null) {
            this.setResourcesIncluded(new ArrayList<Resource>(resourcesIncluded.length));
        }
        for (Resource ele : resourcesIncluded) {
            this.resourcesIncluded.add(ele);
        }
        return this;
    }

    public Evidence withResourcesIncluded(Collection<Resource> resourcesIncluded) {
        this.setResourcesIncluded(resourcesIncluded);
        return this;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public Evidence withAttributes(Map<String, String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public Evidence addAttributesEntry(String key, String value) {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, String>();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public Evidence clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public void setIamId(String iamId) {
        this.iamId = iamId;
    }

    public String getIamId() {
        return this.iamId;
    }

    public Evidence withIamId(String iamId) {
        this.setIamId(iamId);
        return this;
    }

    public void setComplianceCheck(String complianceCheck) {
        this.complianceCheck = complianceCheck;
    }

    public String getComplianceCheck() {
        return this.complianceCheck;
    }

    public Evidence withComplianceCheck(String complianceCheck) {
        this.setComplianceCheck(complianceCheck);
        return this;
    }

    public void setAwsOrganization(String awsOrganization) {
        this.awsOrganization = awsOrganization;
    }

    public String getAwsOrganization() {
        return this.awsOrganization;
    }

    public Evidence withAwsOrganization(String awsOrganization) {
        this.setAwsOrganization(awsOrganization);
        return this;
    }

    public void setAwsAccountId(String awsAccountId) {
        this.awsAccountId = awsAccountId;
    }

    public String getAwsAccountId() {
        return this.awsAccountId;
    }

    public Evidence withAwsAccountId(String awsAccountId) {
        this.setAwsAccountId(awsAccountId);
        return this;
    }

    public void setEvidenceFolderId(String evidenceFolderId) {
        this.evidenceFolderId = evidenceFolderId;
    }

    public String getEvidenceFolderId() {
        return this.evidenceFolderId;
    }

    public Evidence withEvidenceFolderId(String evidenceFolderId) {
        this.setEvidenceFolderId(evidenceFolderId);
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Evidence withId(String id) {
        this.setId(id);
        return this;
    }

    public void setAssessmentReportSelection(String assessmentReportSelection) {
        this.assessmentReportSelection = assessmentReportSelection;
    }

    public String getAssessmentReportSelection() {
        return this.assessmentReportSelection;
    }

    public Evidence withAssessmentReportSelection(String assessmentReportSelection) {
        this.setAssessmentReportSelection(assessmentReportSelection);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDataSource() != null) {
            sb.append("DataSource: ").append(this.getDataSource()).append(",");
        }
        if (this.getEvidenceAwsAccountId() != null) {
            sb.append("EvidenceAwsAccountId: ").append(this.getEvidenceAwsAccountId()).append(",");
        }
        if (this.getTime() != null) {
            sb.append("Time: ").append(this.getTime()).append(",");
        }
        if (this.getEventSource() != null) {
            sb.append("EventSource: ").append(this.getEventSource()).append(",");
        }
        if (this.getEventName() != null) {
            sb.append("EventName: ").append(this.getEventName()).append(",");
        }
        if (this.getEvidenceByType() != null) {
            sb.append("EvidenceByType: ").append(this.getEvidenceByType()).append(",");
        }
        if (this.getResourcesIncluded() != null) {
            sb.append("ResourcesIncluded: ").append(this.getResourcesIncluded()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes()).append(",");
        }
        if (this.getIamId() != null) {
            sb.append("IamId: ").append(this.getIamId()).append(",");
        }
        if (this.getComplianceCheck() != null) {
            sb.append("ComplianceCheck: ").append(this.getComplianceCheck()).append(",");
        }
        if (this.getAwsOrganization() != null) {
            sb.append("AwsOrganization: ").append(this.getAwsOrganization()).append(",");
        }
        if (this.getAwsAccountId() != null) {
            sb.append("AwsAccountId: ").append(this.getAwsAccountId()).append(",");
        }
        if (this.getEvidenceFolderId() != null) {
            sb.append("EvidenceFolderId: ").append(this.getEvidenceFolderId()).append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getAssessmentReportSelection() != null) {
            sb.append("AssessmentReportSelection: ").append(this.getAssessmentReportSelection());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Evidence)) {
            return false;
        }
        Evidence other = (Evidence)obj;
        if (other.getDataSource() == null ^ this.getDataSource() == null) {
            return false;
        }
        if (other.getDataSource() != null && !other.getDataSource().equals(this.getDataSource())) {
            return false;
        }
        if (other.getEvidenceAwsAccountId() == null ^ this.getEvidenceAwsAccountId() == null) {
            return false;
        }
        if (other.getEvidenceAwsAccountId() != null && !other.getEvidenceAwsAccountId().equals(this.getEvidenceAwsAccountId())) {
            return false;
        }
        if (other.getTime() == null ^ this.getTime() == null) {
            return false;
        }
        if (other.getTime() != null && !other.getTime().equals(this.getTime())) {
            return false;
        }
        if (other.getEventSource() == null ^ this.getEventSource() == null) {
            return false;
        }
        if (other.getEventSource() != null && !other.getEventSource().equals(this.getEventSource())) {
            return false;
        }
        if (other.getEventName() == null ^ this.getEventName() == null) {
            return false;
        }
        if (other.getEventName() != null && !other.getEventName().equals(this.getEventName())) {
            return false;
        }
        if (other.getEvidenceByType() == null ^ this.getEvidenceByType() == null) {
            return false;
        }
        if (other.getEvidenceByType() != null && !other.getEvidenceByType().equals(this.getEvidenceByType())) {
            return false;
        }
        if (other.getResourcesIncluded() == null ^ this.getResourcesIncluded() == null) {
            return false;
        }
        if (other.getResourcesIncluded() != null && !other.getResourcesIncluded().equals(this.getResourcesIncluded())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getIamId() == null ^ this.getIamId() == null) {
            return false;
        }
        if (other.getIamId() != null && !other.getIamId().equals(this.getIamId())) {
            return false;
        }
        if (other.getComplianceCheck() == null ^ this.getComplianceCheck() == null) {
            return false;
        }
        if (other.getComplianceCheck() != null && !other.getComplianceCheck().equals(this.getComplianceCheck())) {
            return false;
        }
        if (other.getAwsOrganization() == null ^ this.getAwsOrganization() == null) {
            return false;
        }
        if (other.getAwsOrganization() != null && !other.getAwsOrganization().equals(this.getAwsOrganization())) {
            return false;
        }
        if (other.getAwsAccountId() == null ^ this.getAwsAccountId() == null) {
            return false;
        }
        if (other.getAwsAccountId() != null && !other.getAwsAccountId().equals(this.getAwsAccountId())) {
            return false;
        }
        if (other.getEvidenceFolderId() == null ^ this.getEvidenceFolderId() == null) {
            return false;
        }
        if (other.getEvidenceFolderId() != null && !other.getEvidenceFolderId().equals(this.getEvidenceFolderId())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getAssessmentReportSelection() == null ^ this.getAssessmentReportSelection() == null) {
            return false;
        }
        return other.getAssessmentReportSelection() == null || other.getAssessmentReportSelection().equals(this.getAssessmentReportSelection());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDataSource() == null ? 0 : this.getDataSource().hashCode());
        hashCode = 31 * hashCode + (this.getEvidenceAwsAccountId() == null ? 0 : this.getEvidenceAwsAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getTime() == null ? 0 : this.getTime().hashCode());
        hashCode = 31 * hashCode + (this.getEventSource() == null ? 0 : this.getEventSource().hashCode());
        hashCode = 31 * hashCode + (this.getEventName() == null ? 0 : this.getEventName().hashCode());
        hashCode = 31 * hashCode + (this.getEvidenceByType() == null ? 0 : this.getEvidenceByType().hashCode());
        hashCode = 31 * hashCode + (this.getResourcesIncluded() == null ? 0 : this.getResourcesIncluded().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getIamId() == null ? 0 : this.getIamId().hashCode());
        hashCode = 31 * hashCode + (this.getComplianceCheck() == null ? 0 : this.getComplianceCheck().hashCode());
        hashCode = 31 * hashCode + (this.getAwsOrganization() == null ? 0 : this.getAwsOrganization().hashCode());
        hashCode = 31 * hashCode + (this.getAwsAccountId() == null ? 0 : this.getAwsAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getEvidenceFolderId() == null ? 0 : this.getEvidenceFolderId().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getAssessmentReportSelection() == null ? 0 : this.getAssessmentReportSelection().hashCode());
        return hashCode;
    }

    public Evidence clone() {
        try {
            return (Evidence)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EvidenceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

