/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.athena.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.athena.model.SessionSummary;

@SdkInternalApi
public class SessionSummaryMarshaller {
    private static final MarshallingInfo<String> SESSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SessionId").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<StructuredPojo> ENGINEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EngineVersion").build();
    private static final MarshallingInfo<String> NOTEBOOKVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotebookVersion").build();
    private static final MarshallingInfo<StructuredPojo> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final SessionSummaryMarshaller instance = new SessionSummaryMarshaller();

    public static SessionSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(SessionSummary sessionSummary, ProtocolMarshaller protocolMarshaller) {
        if (sessionSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)sessionSummary.getSessionId(), SESSIONID_BINDING);
            protocolMarshaller.marshall((Object)sessionSummary.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)sessionSummary.getEngineVersion(), ENGINEVERSION_BINDING);
            protocolMarshaller.marshall((Object)sessionSummary.getNotebookVersion(), NOTEBOOKVERSION_BINDING);
            protocolMarshaller.marshall((Object)sessionSummary.getStatus(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

