/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.athena.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.athena.model.PreparedStatement;
import java.util.Date;

@SdkInternalApi
public class PreparedStatementMarshaller {
    private static final MarshallingInfo<String> STATEMENTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatementName").build();
    private static final MarshallingInfo<String> QUERYSTATEMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QueryStatement").build();
    private static final MarshallingInfo<String> WORKGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WorkGroupName").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<Date> LASTMODIFIEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedTime").timestampFormat("unixTimestamp").build();
    private static final PreparedStatementMarshaller instance = new PreparedStatementMarshaller();

    public static PreparedStatementMarshaller getInstance() {
        return instance;
    }

    public void marshall(PreparedStatement preparedStatement, ProtocolMarshaller protocolMarshaller) {
        if (preparedStatement == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)preparedStatement.getStatementName(), STATEMENTNAME_BINDING);
            protocolMarshaller.marshall((Object)preparedStatement.getQueryStatement(), QUERYSTATEMENT_BINDING);
            protocolMarshaller.marshall((Object)preparedStatement.getWorkGroupName(), WORKGROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)preparedStatement.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)preparedStatement.getLastModifiedTime(), LASTMODIFIEDTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

