/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.athena.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.athena.model.QueryStagePlanNode;
import com.amazonaws.services.athena.model.transform.QueryStageMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class QueryStage
implements Serializable,
Cloneable,
StructuredPojo {
    private Long stageId;
    private String state;
    private Long outputBytes;
    private Long outputRows;
    private Long inputBytes;
    private Long inputRows;
    private Long executionTime;
    private QueryStagePlanNode queryStagePlan;
    private List<QueryStage> subStages;

    public void setStageId(Long stageId) {
        this.stageId = stageId;
    }

    public Long getStageId() {
        return this.stageId;
    }

    public QueryStage withStageId(Long stageId) {
        this.setStageId(stageId);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public QueryStage withState(String state) {
        this.setState(state);
        return this;
    }

    public void setOutputBytes(Long outputBytes) {
        this.outputBytes = outputBytes;
    }

    public Long getOutputBytes() {
        return this.outputBytes;
    }

    public QueryStage withOutputBytes(Long outputBytes) {
        this.setOutputBytes(outputBytes);
        return this;
    }

    public void setOutputRows(Long outputRows) {
        this.outputRows = outputRows;
    }

    public Long getOutputRows() {
        return this.outputRows;
    }

    public QueryStage withOutputRows(Long outputRows) {
        this.setOutputRows(outputRows);
        return this;
    }

    public void setInputBytes(Long inputBytes) {
        this.inputBytes = inputBytes;
    }

    public Long getInputBytes() {
        return this.inputBytes;
    }

    public QueryStage withInputBytes(Long inputBytes) {
        this.setInputBytes(inputBytes);
        return this;
    }

    public void setInputRows(Long inputRows) {
        this.inputRows = inputRows;
    }

    public Long getInputRows() {
        return this.inputRows;
    }

    public QueryStage withInputRows(Long inputRows) {
        this.setInputRows(inputRows);
        return this;
    }

    public void setExecutionTime(Long executionTime) {
        this.executionTime = executionTime;
    }

    public Long getExecutionTime() {
        return this.executionTime;
    }

    public QueryStage withExecutionTime(Long executionTime) {
        this.setExecutionTime(executionTime);
        return this;
    }

    public void setQueryStagePlan(QueryStagePlanNode queryStagePlan) {
        this.queryStagePlan = queryStagePlan;
    }

    public QueryStagePlanNode getQueryStagePlan() {
        return this.queryStagePlan;
    }

    public QueryStage withQueryStagePlan(QueryStagePlanNode queryStagePlan) {
        this.setQueryStagePlan(queryStagePlan);
        return this;
    }

    public List<QueryStage> getSubStages() {
        return this.subStages;
    }

    public void setSubStages(Collection<QueryStage> subStages) {
        if (subStages == null) {
            this.subStages = null;
            return;
        }
        this.subStages = new ArrayList<QueryStage>(subStages);
    }

    public QueryStage withSubStages(QueryStage ... subStages) {
        if (this.subStages == null) {
            this.setSubStages(new ArrayList<QueryStage>(subStages.length));
        }
        for (QueryStage ele : subStages) {
            this.subStages.add(ele);
        }
        return this;
    }

    public QueryStage withSubStages(Collection<QueryStage> subStages) {
        this.setSubStages(subStages);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStageId() != null) {
            sb.append("StageId: ").append(this.getStageId()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getOutputBytes() != null) {
            sb.append("OutputBytes: ").append(this.getOutputBytes()).append(",");
        }
        if (this.getOutputRows() != null) {
            sb.append("OutputRows: ").append(this.getOutputRows()).append(",");
        }
        if (this.getInputBytes() != null) {
            sb.append("InputBytes: ").append(this.getInputBytes()).append(",");
        }
        if (this.getInputRows() != null) {
            sb.append("InputRows: ").append(this.getInputRows()).append(",");
        }
        if (this.getExecutionTime() != null) {
            sb.append("ExecutionTime: ").append(this.getExecutionTime()).append(",");
        }
        if (this.getQueryStagePlan() != null) {
            sb.append("QueryStagePlan: ").append(this.getQueryStagePlan()).append(",");
        }
        if (this.getSubStages() != null) {
            sb.append("SubStages: ").append(this.getSubStages());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryStage)) {
            return false;
        }
        QueryStage other = (QueryStage)obj;
        if (other.getStageId() == null ^ this.getStageId() == null) {
            return false;
        }
        if (other.getStageId() != null && !other.getStageId().equals(this.getStageId())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getOutputBytes() == null ^ this.getOutputBytes() == null) {
            return false;
        }
        if (other.getOutputBytes() != null && !other.getOutputBytes().equals(this.getOutputBytes())) {
            return false;
        }
        if (other.getOutputRows() == null ^ this.getOutputRows() == null) {
            return false;
        }
        if (other.getOutputRows() != null && !other.getOutputRows().equals(this.getOutputRows())) {
            return false;
        }
        if (other.getInputBytes() == null ^ this.getInputBytes() == null) {
            return false;
        }
        if (other.getInputBytes() != null && !other.getInputBytes().equals(this.getInputBytes())) {
            return false;
        }
        if (other.getInputRows() == null ^ this.getInputRows() == null) {
            return false;
        }
        if (other.getInputRows() != null && !other.getInputRows().equals(this.getInputRows())) {
            return false;
        }
        if (other.getExecutionTime() == null ^ this.getExecutionTime() == null) {
            return false;
        }
        if (other.getExecutionTime() != null && !other.getExecutionTime().equals(this.getExecutionTime())) {
            return false;
        }
        if (other.getQueryStagePlan() == null ^ this.getQueryStagePlan() == null) {
            return false;
        }
        if (other.getQueryStagePlan() != null && !other.getQueryStagePlan().equals(this.getQueryStagePlan())) {
            return false;
        }
        if (other.getSubStages() == null ^ this.getSubStages() == null) {
            return false;
        }
        return other.getSubStages() == null || other.getSubStages().equals(this.getSubStages());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStageId() == null ? 0 : this.getStageId().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getOutputBytes() == null ? 0 : this.getOutputBytes().hashCode());
        hashCode = 31 * hashCode + (this.getOutputRows() == null ? 0 : this.getOutputRows().hashCode());
        hashCode = 31 * hashCode + (this.getInputBytes() == null ? 0 : this.getInputBytes().hashCode());
        hashCode = 31 * hashCode + (this.getInputRows() == null ? 0 : this.getInputRows().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionTime() == null ? 0 : this.getExecutionTime().hashCode());
        hashCode = 31 * hashCode + (this.getQueryStagePlan() == null ? 0 : this.getQueryStagePlan().hashCode());
        hashCode = 31 * hashCode + (this.getSubStages() == null ? 0 : this.getSubStages().hashCode());
        return hashCode;
    }

    public QueryStage clone() {
        try {
            return (QueryStage)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        QueryStageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

