/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apptest.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.apptest.model.transform.BatchMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Batch
implements Serializable,
Cloneable,
StructuredPojo {
    private String batchJobName;
    private Map<String, String> batchJobParameters;
    private List<String> exportDataSetNames;

    public void setBatchJobName(String batchJobName) {
        this.batchJobName = batchJobName;
    }

    public String getBatchJobName() {
        return this.batchJobName;
    }

    public Batch withBatchJobName(String batchJobName) {
        this.setBatchJobName(batchJobName);
        return this;
    }

    public Map<String, String> getBatchJobParameters() {
        return this.batchJobParameters;
    }

    public void setBatchJobParameters(Map<String, String> batchJobParameters) {
        this.batchJobParameters = batchJobParameters;
    }

    public Batch withBatchJobParameters(Map<String, String> batchJobParameters) {
        this.setBatchJobParameters(batchJobParameters);
        return this;
    }

    public Batch addBatchJobParametersEntry(String key, String value) {
        if (null == this.batchJobParameters) {
            this.batchJobParameters = new HashMap<String, String>();
        }
        if (this.batchJobParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.batchJobParameters.put(key, value);
        return this;
    }

    public Batch clearBatchJobParametersEntries() {
        this.batchJobParameters = null;
        return this;
    }

    public List<String> getExportDataSetNames() {
        return this.exportDataSetNames;
    }

    public void setExportDataSetNames(Collection<String> exportDataSetNames) {
        if (exportDataSetNames == null) {
            this.exportDataSetNames = null;
            return;
        }
        this.exportDataSetNames = new ArrayList<String>(exportDataSetNames);
    }

    public Batch withExportDataSetNames(String ... exportDataSetNames) {
        if (this.exportDataSetNames == null) {
            this.setExportDataSetNames(new ArrayList<String>(exportDataSetNames.length));
        }
        for (String ele : exportDataSetNames) {
            this.exportDataSetNames.add(ele);
        }
        return this;
    }

    public Batch withExportDataSetNames(Collection<String> exportDataSetNames) {
        this.setExportDataSetNames(exportDataSetNames);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBatchJobName() != null) {
            sb.append("BatchJobName: ").append(this.getBatchJobName()).append(",");
        }
        if (this.getBatchJobParameters() != null) {
            sb.append("BatchJobParameters: ").append(this.getBatchJobParameters()).append(",");
        }
        if (this.getExportDataSetNames() != null) {
            sb.append("ExportDataSetNames: ").append(this.getExportDataSetNames());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Batch)) {
            return false;
        }
        Batch other = (Batch)obj;
        if (other.getBatchJobName() == null ^ this.getBatchJobName() == null) {
            return false;
        }
        if (other.getBatchJobName() != null && !other.getBatchJobName().equals(this.getBatchJobName())) {
            return false;
        }
        if (other.getBatchJobParameters() == null ^ this.getBatchJobParameters() == null) {
            return false;
        }
        if (other.getBatchJobParameters() != null && !other.getBatchJobParameters().equals(this.getBatchJobParameters())) {
            return false;
        }
        if (other.getExportDataSetNames() == null ^ this.getExportDataSetNames() == null) {
            return false;
        }
        return other.getExportDataSetNames() == null || other.getExportDataSetNames().equals(this.getExportDataSetNames());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBatchJobName() == null ? 0 : this.getBatchJobName().hashCode());
        hashCode = 31 * hashCode + (this.getBatchJobParameters() == null ? 0 : this.getBatchJobParameters().hashCode());
        hashCode = 31 * hashCode + (this.getExportDataSetNames() == null ? 0 : this.getExportDataSetNames().hashCode());
        return hashCode;
    }

    public Batch clone() {
        try {
            return (Batch)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

