/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appregistry.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appregistry.model.ResourceIntegrations;
import com.amazonaws.services.appregistry.model.transform.ResourceMarshaller;
import java.io.Serializable;
import java.util.Date;

public class Resource
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String arn;
    private Date associationTime;
    private ResourceIntegrations integrations;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Resource withName(String name) {
        this.setName(name);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Resource withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setAssociationTime(Date associationTime) {
        this.associationTime = associationTime;
    }

    public Date getAssociationTime() {
        return this.associationTime;
    }

    public Resource withAssociationTime(Date associationTime) {
        this.setAssociationTime(associationTime);
        return this;
    }

    public void setIntegrations(ResourceIntegrations integrations) {
        this.integrations = integrations;
    }

    public ResourceIntegrations getIntegrations() {
        return this.integrations;
    }

    public Resource withIntegrations(ResourceIntegrations integrations) {
        this.setIntegrations(integrations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getAssociationTime() != null) {
            sb.append("AssociationTime: ").append(this.getAssociationTime()).append(",");
        }
        if (this.getIntegrations() != null) {
            sb.append("Integrations: ").append(this.getIntegrations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getAssociationTime() == null ^ this.getAssociationTime() == null) {
            return false;
        }
        if (other.getAssociationTime() != null && !other.getAssociationTime().equals(this.getAssociationTime())) {
            return false;
        }
        if (other.getIntegrations() == null ^ this.getIntegrations() == null) {
            return false;
        }
        return other.getIntegrations() == null || other.getIntegrations().equals(this.getIntegrations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getAssociationTime() == null ? 0 : this.getAssociationTime().hashCode());
        hashCode = 31 * hashCode + (this.getIntegrations() == null ? 0 : this.getIntegrations().hashCode());
        return hashCode;
    }

    public Resource clone() {
        try {
            return (Resource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

