/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationautoscaling;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.applicationautoscaling.AWSApplicationAutoScalingAsync;
import com.amazonaws.services.applicationautoscaling.AWSApplicationAutoScalingAsyncClientBuilder;
import com.amazonaws.services.applicationautoscaling.AWSApplicationAutoScalingClient;
import com.amazonaws.services.applicationautoscaling.model.DeleteScalingPolicyRequest;
import com.amazonaws.services.applicationautoscaling.model.DeleteScalingPolicyResult;
import com.amazonaws.services.applicationautoscaling.model.DeleteScheduledActionRequest;
import com.amazonaws.services.applicationautoscaling.model.DeleteScheduledActionResult;
import com.amazonaws.services.applicationautoscaling.model.DeregisterScalableTargetRequest;
import com.amazonaws.services.applicationautoscaling.model.DeregisterScalableTargetResult;
import com.amazonaws.services.applicationautoscaling.model.DescribeScalableTargetsRequest;
import com.amazonaws.services.applicationautoscaling.model.DescribeScalableTargetsResult;
import com.amazonaws.services.applicationautoscaling.model.DescribeScalingActivitiesRequest;
import com.amazonaws.services.applicationautoscaling.model.DescribeScalingActivitiesResult;
import com.amazonaws.services.applicationautoscaling.model.DescribeScalingPoliciesRequest;
import com.amazonaws.services.applicationautoscaling.model.DescribeScalingPoliciesResult;
import com.amazonaws.services.applicationautoscaling.model.DescribeScheduledActionsRequest;
import com.amazonaws.services.applicationautoscaling.model.DescribeScheduledActionsResult;
import com.amazonaws.services.applicationautoscaling.model.ListTagsForResourceRequest;
import com.amazonaws.services.applicationautoscaling.model.ListTagsForResourceResult;
import com.amazonaws.services.applicationautoscaling.model.PutScalingPolicyRequest;
import com.amazonaws.services.applicationautoscaling.model.PutScalingPolicyResult;
import com.amazonaws.services.applicationautoscaling.model.PutScheduledActionRequest;
import com.amazonaws.services.applicationautoscaling.model.PutScheduledActionResult;
import com.amazonaws.services.applicationautoscaling.model.RegisterScalableTargetRequest;
import com.amazonaws.services.applicationautoscaling.model.RegisterScalableTargetResult;
import com.amazonaws.services.applicationautoscaling.model.TagResourceRequest;
import com.amazonaws.services.applicationautoscaling.model.TagResourceResult;
import com.amazonaws.services.applicationautoscaling.model.UntagResourceRequest;
import com.amazonaws.services.applicationautoscaling.model.UntagResourceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSApplicationAutoScalingAsyncClient
extends AWSApplicationAutoScalingClient
implements AWSApplicationAutoScalingAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AWSApplicationAutoScalingAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AWSApplicationAutoScalingAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSApplicationAutoScalingAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSApplicationAutoScalingAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSApplicationAutoScalingAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AWSApplicationAutoScalingAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSApplicationAutoScalingAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSApplicationAutoScalingAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSApplicationAutoScalingAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AWSApplicationAutoScalingAsyncClientBuilder asyncBuilder() {
        return AWSApplicationAutoScalingAsyncClientBuilder.standard();
    }

    AWSApplicationAutoScalingAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSApplicationAutoScalingAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DeleteScalingPolicyResult> deleteScalingPolicyAsync(DeleteScalingPolicyRequest request) {
        return this.deleteScalingPolicyAsync(request, null);
    }

    @Override
    public Future<DeleteScalingPolicyResult> deleteScalingPolicyAsync(DeleteScalingPolicyRequest request, final AsyncHandler<DeleteScalingPolicyRequest, DeleteScalingPolicyResult> asyncHandler) {
        final DeleteScalingPolicyRequest finalRequest = (DeleteScalingPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteScalingPolicyResult>(){

            @Override
            public DeleteScalingPolicyResult call() throws Exception {
                DeleteScalingPolicyResult result = null;
                try {
                    result = AWSApplicationAutoScalingAsyncClient.this.executeDeleteScalingPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteScheduledActionResult> deleteScheduledActionAsync(DeleteScheduledActionRequest request) {
        return this.deleteScheduledActionAsync(request, null);
    }

    @Override
    public Future<DeleteScheduledActionResult> deleteScheduledActionAsync(DeleteScheduledActionRequest request, final AsyncHandler<DeleteScheduledActionRequest, DeleteScheduledActionResult> asyncHandler) {
        final DeleteScheduledActionRequest finalRequest = (DeleteScheduledActionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteScheduledActionResult>(){

            @Override
            public DeleteScheduledActionResult call() throws Exception {
                DeleteScheduledActionResult result = null;
                try {
                    result = AWSApplicationAutoScalingAsyncClient.this.executeDeleteScheduledAction(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeregisterScalableTargetResult> deregisterScalableTargetAsync(DeregisterScalableTargetRequest request) {
        return this.deregisterScalableTargetAsync(request, null);
    }

    @Override
    public Future<DeregisterScalableTargetResult> deregisterScalableTargetAsync(DeregisterScalableTargetRequest request, final AsyncHandler<DeregisterScalableTargetRequest, DeregisterScalableTargetResult> asyncHandler) {
        final DeregisterScalableTargetRequest finalRequest = (DeregisterScalableTargetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeregisterScalableTargetResult>(){

            @Override
            public DeregisterScalableTargetResult call() throws Exception {
                DeregisterScalableTargetResult result = null;
                try {
                    result = AWSApplicationAutoScalingAsyncClient.this.executeDeregisterScalableTarget(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeScalableTargetsResult> describeScalableTargetsAsync(DescribeScalableTargetsRequest request) {
        return this.describeScalableTargetsAsync(request, null);
    }

    @Override
    public Future<DescribeScalableTargetsResult> describeScalableTargetsAsync(DescribeScalableTargetsRequest request, final AsyncHandler<DescribeScalableTargetsRequest, DescribeScalableTargetsResult> asyncHandler) {
        final DescribeScalableTargetsRequest finalRequest = (DescribeScalableTargetsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeScalableTargetsResult>(){

            @Override
            public DescribeScalableTargetsResult call() throws Exception {
                DescribeScalableTargetsResult result = null;
                try {
                    result = AWSApplicationAutoScalingAsyncClient.this.executeDescribeScalableTargets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeScalingActivitiesResult> describeScalingActivitiesAsync(DescribeScalingActivitiesRequest request) {
        return this.describeScalingActivitiesAsync(request, null);
    }

    @Override
    public Future<DescribeScalingActivitiesResult> describeScalingActivitiesAsync(DescribeScalingActivitiesRequest request, final AsyncHandler<DescribeScalingActivitiesRequest, DescribeScalingActivitiesResult> asyncHandler) {
        final DescribeScalingActivitiesRequest finalRequest = (DescribeScalingActivitiesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeScalingActivitiesResult>(){

            @Override
            public DescribeScalingActivitiesResult call() throws Exception {
                DescribeScalingActivitiesResult result = null;
                try {
                    result = AWSApplicationAutoScalingAsyncClient.this.executeDescribeScalingActivities(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeScalingPoliciesResult> describeScalingPoliciesAsync(DescribeScalingPoliciesRequest request) {
        return this.describeScalingPoliciesAsync(request, null);
    }

    @Override
    public Future<DescribeScalingPoliciesResult> describeScalingPoliciesAsync(DescribeScalingPoliciesRequest request, final AsyncHandler<DescribeScalingPoliciesRequest, DescribeScalingPoliciesResult> asyncHandler) {
        final DescribeScalingPoliciesRequest finalRequest = (DescribeScalingPoliciesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeScalingPoliciesResult>(){

            @Override
            public DescribeScalingPoliciesResult call() throws Exception {
                DescribeScalingPoliciesResult result = null;
                try {
                    result = AWSApplicationAutoScalingAsyncClient.this.executeDescribeScalingPolicies(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeScheduledActionsResult> describeScheduledActionsAsync(DescribeScheduledActionsRequest request) {
        return this.describeScheduledActionsAsync(request, null);
    }

    @Override
    public Future<DescribeScheduledActionsResult> describeScheduledActionsAsync(DescribeScheduledActionsRequest request, final AsyncHandler<DescribeScheduledActionsRequest, DescribeScheduledActionsResult> asyncHandler) {
        final DescribeScheduledActionsRequest finalRequest = (DescribeScheduledActionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeScheduledActionsResult>(){

            @Override
            public DescribeScheduledActionsResult call() throws Exception {
                DescribeScheduledActionsResult result = null;
                try {
                    result = AWSApplicationAutoScalingAsyncClient.this.executeDescribeScheduledActions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSApplicationAutoScalingAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutScalingPolicyResult> putScalingPolicyAsync(PutScalingPolicyRequest request) {
        return this.putScalingPolicyAsync(request, null);
    }

    @Override
    public Future<PutScalingPolicyResult> putScalingPolicyAsync(PutScalingPolicyRequest request, final AsyncHandler<PutScalingPolicyRequest, PutScalingPolicyResult> asyncHandler) {
        final PutScalingPolicyRequest finalRequest = (PutScalingPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutScalingPolicyResult>(){

            @Override
            public PutScalingPolicyResult call() throws Exception {
                PutScalingPolicyResult result = null;
                try {
                    result = AWSApplicationAutoScalingAsyncClient.this.executePutScalingPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutScheduledActionResult> putScheduledActionAsync(PutScheduledActionRequest request) {
        return this.putScheduledActionAsync(request, null);
    }

    @Override
    public Future<PutScheduledActionResult> putScheduledActionAsync(PutScheduledActionRequest request, final AsyncHandler<PutScheduledActionRequest, PutScheduledActionResult> asyncHandler) {
        final PutScheduledActionRequest finalRequest = (PutScheduledActionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutScheduledActionResult>(){

            @Override
            public PutScheduledActionResult call() throws Exception {
                PutScheduledActionResult result = null;
                try {
                    result = AWSApplicationAutoScalingAsyncClient.this.executePutScheduledAction(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RegisterScalableTargetResult> registerScalableTargetAsync(RegisterScalableTargetRequest request) {
        return this.registerScalableTargetAsync(request, null);
    }

    @Override
    public Future<RegisterScalableTargetResult> registerScalableTargetAsync(RegisterScalableTargetRequest request, final AsyncHandler<RegisterScalableTargetRequest, RegisterScalableTargetResult> asyncHandler) {
        final RegisterScalableTargetRequest finalRequest = (RegisterScalableTargetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RegisterScalableTargetResult>(){

            @Override
            public RegisterScalableTargetResult call() throws Exception {
                RegisterScalableTargetResult result = null;
                try {
                    result = AWSApplicationAutoScalingAsyncClient.this.executeRegisterScalableTarget(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSApplicationAutoScalingAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSApplicationAutoScalingAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

