/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appflow.model.PathPrefix;
import com.amazonaws.services.appflow.model.PrefixFormat;
import com.amazonaws.services.appflow.model.PrefixType;
import com.amazonaws.services.appflow.model.transform.PrefixConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PrefixConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String prefixType;
    private String prefixFormat;
    private List<String> pathPrefixHierarchy;

    public void setPrefixType(String prefixType) {
        this.prefixType = prefixType;
    }

    public String getPrefixType() {
        return this.prefixType;
    }

    public PrefixConfig withPrefixType(String prefixType) {
        this.setPrefixType(prefixType);
        return this;
    }

    public PrefixConfig withPrefixType(PrefixType prefixType) {
        this.prefixType = prefixType.toString();
        return this;
    }

    public void setPrefixFormat(String prefixFormat) {
        this.prefixFormat = prefixFormat;
    }

    public String getPrefixFormat() {
        return this.prefixFormat;
    }

    public PrefixConfig withPrefixFormat(String prefixFormat) {
        this.setPrefixFormat(prefixFormat);
        return this;
    }

    public PrefixConfig withPrefixFormat(PrefixFormat prefixFormat) {
        this.prefixFormat = prefixFormat.toString();
        return this;
    }

    public List<String> getPathPrefixHierarchy() {
        return this.pathPrefixHierarchy;
    }

    public void setPathPrefixHierarchy(Collection<String> pathPrefixHierarchy) {
        if (pathPrefixHierarchy == null) {
            this.pathPrefixHierarchy = null;
            return;
        }
        this.pathPrefixHierarchy = new ArrayList<String>(pathPrefixHierarchy);
    }

    public PrefixConfig withPathPrefixHierarchy(String ... pathPrefixHierarchy) {
        if (this.pathPrefixHierarchy == null) {
            this.setPathPrefixHierarchy(new ArrayList<String>(pathPrefixHierarchy.length));
        }
        for (String ele : pathPrefixHierarchy) {
            this.pathPrefixHierarchy.add(ele);
        }
        return this;
    }

    public PrefixConfig withPathPrefixHierarchy(Collection<String> pathPrefixHierarchy) {
        this.setPathPrefixHierarchy(pathPrefixHierarchy);
        return this;
    }

    public PrefixConfig withPathPrefixHierarchy(PathPrefix ... pathPrefixHierarchy) {
        ArrayList<String> pathPrefixHierarchyCopy = new ArrayList<String>(pathPrefixHierarchy.length);
        for (PathPrefix value : pathPrefixHierarchy) {
            pathPrefixHierarchyCopy.add(value.toString());
        }
        if (this.getPathPrefixHierarchy() == null) {
            this.setPathPrefixHierarchy(pathPrefixHierarchyCopy);
        } else {
            this.getPathPrefixHierarchy().addAll(pathPrefixHierarchyCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPrefixType() != null) {
            sb.append("PrefixType: ").append(this.getPrefixType()).append(",");
        }
        if (this.getPrefixFormat() != null) {
            sb.append("PrefixFormat: ").append(this.getPrefixFormat()).append(",");
        }
        if (this.getPathPrefixHierarchy() != null) {
            sb.append("PathPrefixHierarchy: ").append(this.getPathPrefixHierarchy());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrefixConfig)) {
            return false;
        }
        PrefixConfig other = (PrefixConfig)obj;
        if (other.getPrefixType() == null ^ this.getPrefixType() == null) {
            return false;
        }
        if (other.getPrefixType() != null && !other.getPrefixType().equals(this.getPrefixType())) {
            return false;
        }
        if (other.getPrefixFormat() == null ^ this.getPrefixFormat() == null) {
            return false;
        }
        if (other.getPrefixFormat() != null && !other.getPrefixFormat().equals(this.getPrefixFormat())) {
            return false;
        }
        if (other.getPathPrefixHierarchy() == null ^ this.getPathPrefixHierarchy() == null) {
            return false;
        }
        return other.getPathPrefixHierarchy() == null || other.getPathPrefixHierarchy().equals(this.getPathPrefixHierarchy());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPrefixType() == null ? 0 : this.getPrefixType().hashCode());
        hashCode = 31 * hashCode + (this.getPrefixFormat() == null ? 0 : this.getPrefixFormat().hashCode());
        hashCode = 31 * hashCode + (this.getPathPrefixHierarchy() == null ? 0 : this.getPathPrefixHierarchy().hashCode());
        return hashCode;
    }

    public PrefixConfig clone() {
        try {
            return (PrefixConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PrefixConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

