/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigatewayv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.apigatewayv2.model.transform.CorsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Cors
implements Serializable,
Cloneable,
StructuredPojo {
    private Boolean allowCredentials;
    private List<String> allowHeaders;
    private List<String> allowMethods;
    private List<String> allowOrigins;
    private List<String> exposeHeaders;
    private Integer maxAge;

    public void setAllowCredentials(Boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
    }

    public Boolean getAllowCredentials() {
        return this.allowCredentials;
    }

    public Cors withAllowCredentials(Boolean allowCredentials) {
        this.setAllowCredentials(allowCredentials);
        return this;
    }

    public Boolean isAllowCredentials() {
        return this.allowCredentials;
    }

    public List<String> getAllowHeaders() {
        return this.allowHeaders;
    }

    public void setAllowHeaders(Collection<String> allowHeaders) {
        if (allowHeaders == null) {
            this.allowHeaders = null;
            return;
        }
        this.allowHeaders = new ArrayList<String>(allowHeaders);
    }

    public Cors withAllowHeaders(String ... allowHeaders) {
        if (this.allowHeaders == null) {
            this.setAllowHeaders(new ArrayList<String>(allowHeaders.length));
        }
        for (String ele : allowHeaders) {
            this.allowHeaders.add(ele);
        }
        return this;
    }

    public Cors withAllowHeaders(Collection<String> allowHeaders) {
        this.setAllowHeaders(allowHeaders);
        return this;
    }

    public List<String> getAllowMethods() {
        return this.allowMethods;
    }

    public void setAllowMethods(Collection<String> allowMethods) {
        if (allowMethods == null) {
            this.allowMethods = null;
            return;
        }
        this.allowMethods = new ArrayList<String>(allowMethods);
    }

    public Cors withAllowMethods(String ... allowMethods) {
        if (this.allowMethods == null) {
            this.setAllowMethods(new ArrayList<String>(allowMethods.length));
        }
        for (String ele : allowMethods) {
            this.allowMethods.add(ele);
        }
        return this;
    }

    public Cors withAllowMethods(Collection<String> allowMethods) {
        this.setAllowMethods(allowMethods);
        return this;
    }

    public List<String> getAllowOrigins() {
        return this.allowOrigins;
    }

    public void setAllowOrigins(Collection<String> allowOrigins) {
        if (allowOrigins == null) {
            this.allowOrigins = null;
            return;
        }
        this.allowOrigins = new ArrayList<String>(allowOrigins);
    }

    public Cors withAllowOrigins(String ... allowOrigins) {
        if (this.allowOrigins == null) {
            this.setAllowOrigins(new ArrayList<String>(allowOrigins.length));
        }
        for (String ele : allowOrigins) {
            this.allowOrigins.add(ele);
        }
        return this;
    }

    public Cors withAllowOrigins(Collection<String> allowOrigins) {
        this.setAllowOrigins(allowOrigins);
        return this;
    }

    public List<String> getExposeHeaders() {
        return this.exposeHeaders;
    }

    public void setExposeHeaders(Collection<String> exposeHeaders) {
        if (exposeHeaders == null) {
            this.exposeHeaders = null;
            return;
        }
        this.exposeHeaders = new ArrayList<String>(exposeHeaders);
    }

    public Cors withExposeHeaders(String ... exposeHeaders) {
        if (this.exposeHeaders == null) {
            this.setExposeHeaders(new ArrayList<String>(exposeHeaders.length));
        }
        for (String ele : exposeHeaders) {
            this.exposeHeaders.add(ele);
        }
        return this;
    }

    public Cors withExposeHeaders(Collection<String> exposeHeaders) {
        this.setExposeHeaders(exposeHeaders);
        return this;
    }

    public void setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public Cors withMaxAge(Integer maxAge) {
        this.setMaxAge(maxAge);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAllowCredentials() != null) {
            sb.append("AllowCredentials: ").append(this.getAllowCredentials()).append(",");
        }
        if (this.getAllowHeaders() != null) {
            sb.append("AllowHeaders: ").append(this.getAllowHeaders()).append(",");
        }
        if (this.getAllowMethods() != null) {
            sb.append("AllowMethods: ").append(this.getAllowMethods()).append(",");
        }
        if (this.getAllowOrigins() != null) {
            sb.append("AllowOrigins: ").append(this.getAllowOrigins()).append(",");
        }
        if (this.getExposeHeaders() != null) {
            sb.append("ExposeHeaders: ").append(this.getExposeHeaders()).append(",");
        }
        if (this.getMaxAge() != null) {
            sb.append("MaxAge: ").append(this.getMaxAge());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cors)) {
            return false;
        }
        Cors other = (Cors)obj;
        if (other.getAllowCredentials() == null ^ this.getAllowCredentials() == null) {
            return false;
        }
        if (other.getAllowCredentials() != null && !other.getAllowCredentials().equals(this.getAllowCredentials())) {
            return false;
        }
        if (other.getAllowHeaders() == null ^ this.getAllowHeaders() == null) {
            return false;
        }
        if (other.getAllowHeaders() != null && !other.getAllowHeaders().equals(this.getAllowHeaders())) {
            return false;
        }
        if (other.getAllowMethods() == null ^ this.getAllowMethods() == null) {
            return false;
        }
        if (other.getAllowMethods() != null && !other.getAllowMethods().equals(this.getAllowMethods())) {
            return false;
        }
        if (other.getAllowOrigins() == null ^ this.getAllowOrigins() == null) {
            return false;
        }
        if (other.getAllowOrigins() != null && !other.getAllowOrigins().equals(this.getAllowOrigins())) {
            return false;
        }
        if (other.getExposeHeaders() == null ^ this.getExposeHeaders() == null) {
            return false;
        }
        if (other.getExposeHeaders() != null && !other.getExposeHeaders().equals(this.getExposeHeaders())) {
            return false;
        }
        if (other.getMaxAge() == null ^ this.getMaxAge() == null) {
            return false;
        }
        return other.getMaxAge() == null || other.getMaxAge().equals(this.getMaxAge());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAllowCredentials() == null ? 0 : this.getAllowCredentials().hashCode());
        hashCode = 31 * hashCode + (this.getAllowHeaders() == null ? 0 : this.getAllowHeaders().hashCode());
        hashCode = 31 * hashCode + (this.getAllowMethods() == null ? 0 : this.getAllowMethods().hashCode());
        hashCode = 31 * hashCode + (this.getAllowOrigins() == null ? 0 : this.getAllowOrigins().hashCode());
        hashCode = 31 * hashCode + (this.getExposeHeaders() == null ? 0 : this.getExposeHeaders().hashCode());
        hashCode = 31 * hashCode + (this.getMaxAge() == null ? 0 : this.getMaxAge().hashCode());
        return hashCode;
    }

    public Cors clone() {
        try {
            return (Cors)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CorsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

