/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.alexaforbusiness.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.alexaforbusiness.model.RoomData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SearchRoomsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<RoomData> rooms;
    private String nextToken;
    private Integer totalCount;

    public List<RoomData> getRooms() {
        return this.rooms;
    }

    public void setRooms(Collection<RoomData> rooms) {
        if (rooms == null) {
            this.rooms = null;
            return;
        }
        this.rooms = new ArrayList<RoomData>(rooms);
    }

    public SearchRoomsResult withRooms(RoomData ... rooms) {
        if (this.rooms == null) {
            this.setRooms(new ArrayList<RoomData>(rooms.length));
        }
        for (RoomData ele : rooms) {
            this.rooms.add(ele);
        }
        return this;
    }

    public SearchRoomsResult withRooms(Collection<RoomData> rooms) {
        this.setRooms(rooms);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public SearchRoomsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public Integer getTotalCount() {
        return this.totalCount;
    }

    public SearchRoomsResult withTotalCount(Integer totalCount) {
        this.setTotalCount(totalCount);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRooms() != null) {
            sb.append("Rooms: ").append(this.getRooms()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getTotalCount() != null) {
            sb.append("TotalCount: ").append(this.getTotalCount());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchRoomsResult)) {
            return false;
        }
        SearchRoomsResult other = (SearchRoomsResult)obj;
        if (other.getRooms() == null ^ this.getRooms() == null) {
            return false;
        }
        if (other.getRooms() != null && !other.getRooms().equals(this.getRooms())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getTotalCount() == null ^ this.getTotalCount() == null) {
            return false;
        }
        return other.getTotalCount() == null || other.getTotalCount().equals(this.getTotalCount());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRooms() == null ? 0 : this.getRooms().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getTotalCount() == null ? 0 : this.getTotalCount().hashCode());
        return hashCode;
    }

    public SearchRoomsResult clone() {
        try {
            return (SearchRoomsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

