/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.acmpca.model.transform;

import com.amazonaws.services.acmpca.model.CustomExtension;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class CustomExtensionJsonUnmarshaller
implements Unmarshaller<CustomExtension, JsonUnmarshallerContext> {
    private static CustomExtensionJsonUnmarshaller instance;

    public CustomExtension unmarshall(JsonUnmarshallerContext context) throws Exception {
        CustomExtension customExtension = new CustomExtension();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ObjectIdentifier", targetDepth)) {
                    context.nextToken();
                    customExtension.setObjectIdentifier((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Value", targetDepth)) {
                    context.nextToken();
                    customExtension.setValue((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Critical", targetDepth)) {
                    context.nextToken();
                    customExtension.setCritical((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return customExtension;
    }

    public static CustomExtensionJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new CustomExtensionJsonUnmarshaller();
        }
        return instance;
    }
}

