/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.certificatemanager.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.certificatemanager.model.CertificateStatus;
import com.amazonaws.services.certificatemanager.model.CertificateType;
import com.amazonaws.services.certificatemanager.model.ExtendedKeyUsageName;
import com.amazonaws.services.certificatemanager.model.KeyAlgorithm;
import com.amazonaws.services.certificatemanager.model.KeyUsageName;
import com.amazonaws.services.certificatemanager.model.RenewalEligibility;
import com.amazonaws.services.certificatemanager.model.transform.CertificateSummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class CertificateSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private String certificateArn;
    private String domainName;
    private List<String> subjectAlternativeNameSummaries;
    private Boolean hasAdditionalSubjectAlternativeNames;
    private String status;
    private String type;
    private String keyAlgorithm;
    private List<String> keyUsages;
    private List<String> extendedKeyUsages;
    private Boolean inUse;
    private Boolean exported;
    private String renewalEligibility;
    private Date notBefore;
    private Date notAfter;
    private Date createdAt;
    private Date issuedAt;
    private Date importedAt;
    private Date revokedAt;

    public void setCertificateArn(String certificateArn) {
        this.certificateArn = certificateArn;
    }

    public String getCertificateArn() {
        return this.certificateArn;
    }

    public CertificateSummary withCertificateArn(String certificateArn) {
        this.setCertificateArn(certificateArn);
        return this;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public CertificateSummary withDomainName(String domainName) {
        this.setDomainName(domainName);
        return this;
    }

    public List<String> getSubjectAlternativeNameSummaries() {
        return this.subjectAlternativeNameSummaries;
    }

    public void setSubjectAlternativeNameSummaries(Collection<String> subjectAlternativeNameSummaries) {
        if (subjectAlternativeNameSummaries == null) {
            this.subjectAlternativeNameSummaries = null;
            return;
        }
        this.subjectAlternativeNameSummaries = new ArrayList<String>(subjectAlternativeNameSummaries);
    }

    public CertificateSummary withSubjectAlternativeNameSummaries(String ... subjectAlternativeNameSummaries) {
        if (this.subjectAlternativeNameSummaries == null) {
            this.setSubjectAlternativeNameSummaries(new ArrayList<String>(subjectAlternativeNameSummaries.length));
        }
        for (String ele : subjectAlternativeNameSummaries) {
            this.subjectAlternativeNameSummaries.add(ele);
        }
        return this;
    }

    public CertificateSummary withSubjectAlternativeNameSummaries(Collection<String> subjectAlternativeNameSummaries) {
        this.setSubjectAlternativeNameSummaries(subjectAlternativeNameSummaries);
        return this;
    }

    public void setHasAdditionalSubjectAlternativeNames(Boolean hasAdditionalSubjectAlternativeNames) {
        this.hasAdditionalSubjectAlternativeNames = hasAdditionalSubjectAlternativeNames;
    }

    public Boolean getHasAdditionalSubjectAlternativeNames() {
        return this.hasAdditionalSubjectAlternativeNames;
    }

    public CertificateSummary withHasAdditionalSubjectAlternativeNames(Boolean hasAdditionalSubjectAlternativeNames) {
        this.setHasAdditionalSubjectAlternativeNames(hasAdditionalSubjectAlternativeNames);
        return this;
    }

    public Boolean isHasAdditionalSubjectAlternativeNames() {
        return this.hasAdditionalSubjectAlternativeNames;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public CertificateSummary withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public CertificateSummary withStatus(CertificateStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public CertificateSummary withType(String type) {
        this.setType(type);
        return this;
    }

    public CertificateSummary withType(CertificateType type) {
        this.type = type.toString();
        return this;
    }

    public void setKeyAlgorithm(String keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public CertificateSummary withKeyAlgorithm(String keyAlgorithm) {
        this.setKeyAlgorithm(keyAlgorithm);
        return this;
    }

    public CertificateSummary withKeyAlgorithm(KeyAlgorithm keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm.toString();
        return this;
    }

    public List<String> getKeyUsages() {
        return this.keyUsages;
    }

    public void setKeyUsages(Collection<String> keyUsages) {
        if (keyUsages == null) {
            this.keyUsages = null;
            return;
        }
        this.keyUsages = new ArrayList<String>(keyUsages);
    }

    public CertificateSummary withKeyUsages(String ... keyUsages) {
        if (this.keyUsages == null) {
            this.setKeyUsages(new ArrayList<String>(keyUsages.length));
        }
        for (String ele : keyUsages) {
            this.keyUsages.add(ele);
        }
        return this;
    }

    public CertificateSummary withKeyUsages(Collection<String> keyUsages) {
        this.setKeyUsages(keyUsages);
        return this;
    }

    public CertificateSummary withKeyUsages(KeyUsageName ... keyUsages) {
        ArrayList<String> keyUsagesCopy = new ArrayList<String>(keyUsages.length);
        for (KeyUsageName value : keyUsages) {
            keyUsagesCopy.add(value.toString());
        }
        if (this.getKeyUsages() == null) {
            this.setKeyUsages(keyUsagesCopy);
        } else {
            this.getKeyUsages().addAll(keyUsagesCopy);
        }
        return this;
    }

    public List<String> getExtendedKeyUsages() {
        return this.extendedKeyUsages;
    }

    public void setExtendedKeyUsages(Collection<String> extendedKeyUsages) {
        if (extendedKeyUsages == null) {
            this.extendedKeyUsages = null;
            return;
        }
        this.extendedKeyUsages = new ArrayList<String>(extendedKeyUsages);
    }

    public CertificateSummary withExtendedKeyUsages(String ... extendedKeyUsages) {
        if (this.extendedKeyUsages == null) {
            this.setExtendedKeyUsages(new ArrayList<String>(extendedKeyUsages.length));
        }
        for (String ele : extendedKeyUsages) {
            this.extendedKeyUsages.add(ele);
        }
        return this;
    }

    public CertificateSummary withExtendedKeyUsages(Collection<String> extendedKeyUsages) {
        this.setExtendedKeyUsages(extendedKeyUsages);
        return this;
    }

    public CertificateSummary withExtendedKeyUsages(ExtendedKeyUsageName ... extendedKeyUsages) {
        ArrayList<String> extendedKeyUsagesCopy = new ArrayList<String>(extendedKeyUsages.length);
        for (ExtendedKeyUsageName value : extendedKeyUsages) {
            extendedKeyUsagesCopy.add(value.toString());
        }
        if (this.getExtendedKeyUsages() == null) {
            this.setExtendedKeyUsages(extendedKeyUsagesCopy);
        } else {
            this.getExtendedKeyUsages().addAll(extendedKeyUsagesCopy);
        }
        return this;
    }

    public void setInUse(Boolean inUse) {
        this.inUse = inUse;
    }

    public Boolean getInUse() {
        return this.inUse;
    }

    public CertificateSummary withInUse(Boolean inUse) {
        this.setInUse(inUse);
        return this;
    }

    public Boolean isInUse() {
        return this.inUse;
    }

    public void setExported(Boolean exported) {
        this.exported = exported;
    }

    public Boolean getExported() {
        return this.exported;
    }

    public CertificateSummary withExported(Boolean exported) {
        this.setExported(exported);
        return this;
    }

    public Boolean isExported() {
        return this.exported;
    }

    public void setRenewalEligibility(String renewalEligibility) {
        this.renewalEligibility = renewalEligibility;
    }

    public String getRenewalEligibility() {
        return this.renewalEligibility;
    }

    public CertificateSummary withRenewalEligibility(String renewalEligibility) {
        this.setRenewalEligibility(renewalEligibility);
        return this;
    }

    public CertificateSummary withRenewalEligibility(RenewalEligibility renewalEligibility) {
        this.renewalEligibility = renewalEligibility.toString();
        return this;
    }

    public void setNotBefore(Date notBefore) {
        this.notBefore = notBefore;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public CertificateSummary withNotBefore(Date notBefore) {
        this.setNotBefore(notBefore);
        return this;
    }

    public void setNotAfter(Date notAfter) {
        this.notAfter = notAfter;
    }

    public Date getNotAfter() {
        return this.notAfter;
    }

    public CertificateSummary withNotAfter(Date notAfter) {
        this.setNotAfter(notAfter);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public CertificateSummary withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setIssuedAt(Date issuedAt) {
        this.issuedAt = issuedAt;
    }

    public Date getIssuedAt() {
        return this.issuedAt;
    }

    public CertificateSummary withIssuedAt(Date issuedAt) {
        this.setIssuedAt(issuedAt);
        return this;
    }

    public void setImportedAt(Date importedAt) {
        this.importedAt = importedAt;
    }

    public Date getImportedAt() {
        return this.importedAt;
    }

    public CertificateSummary withImportedAt(Date importedAt) {
        this.setImportedAt(importedAt);
        return this;
    }

    public void setRevokedAt(Date revokedAt) {
        this.revokedAt = revokedAt;
    }

    public Date getRevokedAt() {
        return this.revokedAt;
    }

    public CertificateSummary withRevokedAt(Date revokedAt) {
        this.setRevokedAt(revokedAt);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCertificateArn() != null) {
            sb.append("CertificateArn: ").append(this.getCertificateArn()).append(",");
        }
        if (this.getDomainName() != null) {
            sb.append("DomainName: ").append(this.getDomainName()).append(",");
        }
        if (this.getSubjectAlternativeNameSummaries() != null) {
            sb.append("SubjectAlternativeNameSummaries: ").append(this.getSubjectAlternativeNameSummaries()).append(",");
        }
        if (this.getHasAdditionalSubjectAlternativeNames() != null) {
            sb.append("HasAdditionalSubjectAlternativeNames: ").append(this.getHasAdditionalSubjectAlternativeNames()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getKeyAlgorithm() != null) {
            sb.append("KeyAlgorithm: ").append(this.getKeyAlgorithm()).append(",");
        }
        if (this.getKeyUsages() != null) {
            sb.append("KeyUsages: ").append(this.getKeyUsages()).append(",");
        }
        if (this.getExtendedKeyUsages() != null) {
            sb.append("ExtendedKeyUsages: ").append(this.getExtendedKeyUsages()).append(",");
        }
        if (this.getInUse() != null) {
            sb.append("InUse: ").append(this.getInUse()).append(",");
        }
        if (this.getExported() != null) {
            sb.append("Exported: ").append(this.getExported()).append(",");
        }
        if (this.getRenewalEligibility() != null) {
            sb.append("RenewalEligibility: ").append(this.getRenewalEligibility()).append(",");
        }
        if (this.getNotBefore() != null) {
            sb.append("NotBefore: ").append(this.getNotBefore()).append(",");
        }
        if (this.getNotAfter() != null) {
            sb.append("NotAfter: ").append(this.getNotAfter()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getIssuedAt() != null) {
            sb.append("IssuedAt: ").append(this.getIssuedAt()).append(",");
        }
        if (this.getImportedAt() != null) {
            sb.append("ImportedAt: ").append(this.getImportedAt()).append(",");
        }
        if (this.getRevokedAt() != null) {
            sb.append("RevokedAt: ").append(this.getRevokedAt());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CertificateSummary)) {
            return false;
        }
        CertificateSummary other = (CertificateSummary)obj;
        if (other.getCertificateArn() == null ^ this.getCertificateArn() == null) {
            return false;
        }
        if (other.getCertificateArn() != null && !other.getCertificateArn().equals(this.getCertificateArn())) {
            return false;
        }
        if (other.getDomainName() == null ^ this.getDomainName() == null) {
            return false;
        }
        if (other.getDomainName() != null && !other.getDomainName().equals(this.getDomainName())) {
            return false;
        }
        if (other.getSubjectAlternativeNameSummaries() == null ^ this.getSubjectAlternativeNameSummaries() == null) {
            return false;
        }
        if (other.getSubjectAlternativeNameSummaries() != null && !other.getSubjectAlternativeNameSummaries().equals(this.getSubjectAlternativeNameSummaries())) {
            return false;
        }
        if (other.getHasAdditionalSubjectAlternativeNames() == null ^ this.getHasAdditionalSubjectAlternativeNames() == null) {
            return false;
        }
        if (other.getHasAdditionalSubjectAlternativeNames() != null && !other.getHasAdditionalSubjectAlternativeNames().equals(this.getHasAdditionalSubjectAlternativeNames())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getKeyAlgorithm() == null ^ this.getKeyAlgorithm() == null) {
            return false;
        }
        if (other.getKeyAlgorithm() != null && !other.getKeyAlgorithm().equals(this.getKeyAlgorithm())) {
            return false;
        }
        if (other.getKeyUsages() == null ^ this.getKeyUsages() == null) {
            return false;
        }
        if (other.getKeyUsages() != null && !other.getKeyUsages().equals(this.getKeyUsages())) {
            return false;
        }
        if (other.getExtendedKeyUsages() == null ^ this.getExtendedKeyUsages() == null) {
            return false;
        }
        if (other.getExtendedKeyUsages() != null && !other.getExtendedKeyUsages().equals(this.getExtendedKeyUsages())) {
            return false;
        }
        if (other.getInUse() == null ^ this.getInUse() == null) {
            return false;
        }
        if (other.getInUse() != null && !other.getInUse().equals(this.getInUse())) {
            return false;
        }
        if (other.getExported() == null ^ this.getExported() == null) {
            return false;
        }
        if (other.getExported() != null && !other.getExported().equals(this.getExported())) {
            return false;
        }
        if (other.getRenewalEligibility() == null ^ this.getRenewalEligibility() == null) {
            return false;
        }
        if (other.getRenewalEligibility() != null && !other.getRenewalEligibility().equals(this.getRenewalEligibility())) {
            return false;
        }
        if (other.getNotBefore() == null ^ this.getNotBefore() == null) {
            return false;
        }
        if (other.getNotBefore() != null && !other.getNotBefore().equals(this.getNotBefore())) {
            return false;
        }
        if (other.getNotAfter() == null ^ this.getNotAfter() == null) {
            return false;
        }
        if (other.getNotAfter() != null && !other.getNotAfter().equals(this.getNotAfter())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getIssuedAt() == null ^ this.getIssuedAt() == null) {
            return false;
        }
        if (other.getIssuedAt() != null && !other.getIssuedAt().equals(this.getIssuedAt())) {
            return false;
        }
        if (other.getImportedAt() == null ^ this.getImportedAt() == null) {
            return false;
        }
        if (other.getImportedAt() != null && !other.getImportedAt().equals(this.getImportedAt())) {
            return false;
        }
        if (other.getRevokedAt() == null ^ this.getRevokedAt() == null) {
            return false;
        }
        return other.getRevokedAt() == null || other.getRevokedAt().equals(this.getRevokedAt());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCertificateArn() == null ? 0 : this.getCertificateArn().hashCode());
        hashCode = 31 * hashCode + (this.getDomainName() == null ? 0 : this.getDomainName().hashCode());
        hashCode = 31 * hashCode + (this.getSubjectAlternativeNameSummaries() == null ? 0 : this.getSubjectAlternativeNameSummaries().hashCode());
        hashCode = 31 * hashCode + (this.getHasAdditionalSubjectAlternativeNames() == null ? 0 : this.getHasAdditionalSubjectAlternativeNames().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getKeyAlgorithm() == null ? 0 : this.getKeyAlgorithm().hashCode());
        hashCode = 31 * hashCode + (this.getKeyUsages() == null ? 0 : this.getKeyUsages().hashCode());
        hashCode = 31 * hashCode + (this.getExtendedKeyUsages() == null ? 0 : this.getExtendedKeyUsages().hashCode());
        hashCode = 31 * hashCode + (this.getInUse() == null ? 0 : this.getInUse().hashCode());
        hashCode = 31 * hashCode + (this.getExported() == null ? 0 : this.getExported().hashCode());
        hashCode = 31 * hashCode + (this.getRenewalEligibility() == null ? 0 : this.getRenewalEligibility().hashCode());
        hashCode = 31 * hashCode + (this.getNotBefore() == null ? 0 : this.getNotBefore().hashCode());
        hashCode = 31 * hashCode + (this.getNotAfter() == null ? 0 : this.getNotAfter().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getIssuedAt() == null ? 0 : this.getIssuedAt().hashCode());
        hashCode = 31 * hashCode + (this.getImportedAt() == null ? 0 : this.getImportedAt().hashCode());
        hashCode = 31 * hashCode + (this.getRevokedAt() == null ? 0 : this.getRevokedAt().hashCode());
        return hashCode;
    }

    public CertificateSummary clone() {
        try {
            return (CertificateSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CertificateSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

