/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.accessanalyzer.model.transform;

import com.amazonaws.services.accessanalyzer.model.PathElement;
import com.amazonaws.services.accessanalyzer.model.transform.SubstringJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class PathElementJsonUnmarshaller
implements Unmarshaller<PathElement, JsonUnmarshallerContext> {
    private static PathElementJsonUnmarshaller instance;

    public PathElement unmarshall(JsonUnmarshallerContext context) throws Exception {
        PathElement pathElement = new PathElement();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("index", targetDepth)) {
                    context.nextToken();
                    pathElement.setIndex((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("key", targetDepth)) {
                    context.nextToken();
                    pathElement.setKey((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("substring", targetDepth)) {
                    context.nextToken();
                    pathElement.setSubstring(SubstringJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("value", targetDepth)) {
                    context.nextToken();
                    pathElement.setValue((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return pathElement;
    }

    public static PathElementJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PathElementJsonUnmarshaller();
        }
        return instance;
    }
}

