/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.materializer;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEScalarFn;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.executor.datawrapper.SqlCharDataWrapper;
import com.amazon.sqlengine.executor.datawrapper.SqlDoubleDataWrapper;
import com.amazon.sqlengine.executor.etree.value.ETConstant;
import com.amazon.sqlengine.executor.etree.value.ETValueExpr;
import com.amazon.sqlengine.executor.etree.value.scalar.ETACosFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETASinFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETATan2Fn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETATanFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETAbsFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETAsciiFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETCeilingFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETCharFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETConcatFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETCosFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETCotFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETCurDateFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETCurTimeFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETCurTimestampFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETCurrentTime1Fn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETDatabaseFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETDayNameFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETDayOfMonthFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETDayOfWeekFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETDayOfYearFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETDegreesFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETExpFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETFloorFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETHourFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETIfNullFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETInsertFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETLTrim;
import com.amazon.sqlengine.executor.etree.value.scalar.ETLeftFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETLengthFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETLocateFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETLog10Fn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETLogFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETLowerFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETMinuteFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETModFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETMonthFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETMonthNameFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETPowerFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETQuarterFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETRTrim;
import com.amazon.sqlengine.executor.etree.value.scalar.ETRadiansFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETRandFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETRepeatFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETReplaceFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETRightFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETRoundFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETSecondFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETSignFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETSinFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETSoundexFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETSpaceFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETSqrtFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETSubstringFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETTanFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETTruncateFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETUCaseFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETUserFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETWeekFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETWeekIsoFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETYearFn;
import com.amazon.sqlengine.executor.materializer.MaterializerContext;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETScalarFnFactory {
    public static ETValueExpr makeNewScalarFn(AEScalarFn aEScalarFn, List<IColumn> list, ArrayList<ETValueExpr> arrayList, MaterializerContext materializerContext) throws ErrorException {
        assert (arrayList.size() == list.size());
        switch (aEScalarFn.getScalarFnId()) {
            case ABS: {
                return new ETAbsFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case ACOS: {
                return new ETACosFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case ASCII: {
                return new ETAsciiFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case ASIN: {
                return new ETASinFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case ATAN: {
                return new ETATanFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case ATAN2: {
                return new ETATan2Fn(aEScalarFn.getColumn(), arrayList, list);
            }
            case CAST: 
            case CONVERT: {
                return arrayList.get(0);
            }
            case CEILING: {
                return new ETCeilingFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case CHAR: {
                return new ETCharFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case CONCAT: {
                return new ETConcatFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case COS: {
                return new ETCosFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case COT: {
                return new ETCotFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case CURDATE: 
            case CURRENT_DATE: {
                return new ETCurDateFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case CURTIME: 
            case CURRENT_TIME: {
                return new ETCurTimeFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case CURRENT_TIME1: {
                return new ETCurrentTime1Fn(aEScalarFn.getColumn(), arrayList, list);
            }
            case CURRENT_TIMESTAMP: 
            case NOW: {
                assert (arrayList.isEmpty());
            }
            case CURRENT_TIMESTAMP1: {
                return new ETCurTimestampFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case DATABASE: {
                return new ETDatabaseFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case DAYNAME: {
                return new ETDayNameFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case DAYOFMONTH: {
                return new ETDayOfMonthFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case DAYOFWEEK: {
                return new ETDayOfWeekFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case DAYOFYEAR: {
                return new ETDayOfYearFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case DEGREES: {
                return new ETDegreesFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case EXP: {
                return new ETExpFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case FLOOR: {
                return new ETFloorFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case HOUR: {
                return new ETHourFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case IFNULL: {
                return new ETIfNullFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case INSERT: {
                return new ETInsertFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case LCASE: 
            case LOWER: {
                return new ETLowerFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case LEFT: {
                return new ETLeftFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case LENGTH: {
                return new ETLengthFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case LOG: {
                return new ETLogFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case LOG10: {
                return new ETLog10Fn(aEScalarFn.getColumn(), arrayList, list);
            }
            case LOCATE2: 
            case LOCATE3: {
                return new ETLocateFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case LTRIM: {
                return new ETLTrim(aEScalarFn.getColumn(), arrayList, list);
            }
            case MINUTE: {
                return new ETMinuteFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case MOD: {
                return new ETModFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case MONTH: {
                return new ETMonthFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case MONTHNAME: {
                return new ETMonthNameFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case NULL: {
                SqlCharDataWrapper sqlCharDataWrapper = new SqlCharDataWrapper(1);
                sqlCharDataWrapper.setNull();
                return new ETConstant(sqlCharDataWrapper);
            }
            case PI: {
                SqlDoubleDataWrapper sqlDoubleDataWrapper = new SqlDoubleDataWrapper(8);
                sqlDoubleDataWrapper.setDouble(Math.PI);
                return new ETConstant(sqlDoubleDataWrapper);
            }
            case POWER: {
                return new ETPowerFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case QUARTER: {
                return new ETQuarterFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case RADIANS: {
                return new ETRadiansFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case RAND0: {
                SqlDoubleDataWrapper sqlDoubleDataWrapper = new SqlDoubleDataWrapper(8);
                sqlDoubleDataWrapper.setDouble(new Random().nextDouble());
                return new ETConstant(sqlDoubleDataWrapper);
            }
            case RAND1: {
                return new ETRandFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case REPEAT: {
                return new ETRepeatFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case REPLACE: {
                return new ETReplaceFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case RIGHT: {
                return new ETRightFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case ROUND: {
                return new ETRoundFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case RTRIM: {
                return new ETRTrim(aEScalarFn.getColumn(), arrayList, list);
            }
            case SECOND: {
                return new ETSecondFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case SIGN: {
                return new ETSignFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case SIN: {
                return new ETSinFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case SOUNDEX: {
                return new ETSoundexFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case SPACE: {
                return new ETSpaceFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case SQRT: {
                return new ETSqrtFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case SUBSTRING2: 
            case SUBSTRING3: {
                return new ETSubstringFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case TAN: {
                return new ETTanFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case TRUNCATE: {
                return new ETTruncateFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case UCASE: 
            case UPPER: {
                return new ETUCaseFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case USER: {
                return new ETUserFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case WEEK: {
                return new ETWeekFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case WEEK_ISO: {
                return new ETWeekIsoFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case YEAR: {
                return new ETYearFn(aEScalarFn.getColumn(), arrayList, list);
            }
        }
        throw SQLEngineExceptionFactory.featureNotImplementedException("scalar function not supported");
    }
}

